# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class EmailAddDomainRequest(BaseModel):
    """
    EmailAddDomainRequest
    """  # noqa: E501

    domain_name: Annotated[str, Field(min_length=0, strict=True, max_length=100)] = (
        Field(description="Unique name for the domain.", alias="domainName")
    )
    dkim_key_length: Optional[StrictInt] = Field(
        default=2048, description="Value for DKIM key length.", alias="dkimKeyLength"
    )
    targeted_daily_traffic: Annotated[int, Field(strict=True, ge=1)] = Field(
        description="Targeted daily traffic.", alias="targetedDailyTraffic"
    )
    application_id: Optional[StrictStr] = Field(
        default=None,
        description="Required for application use in a send request for outbound traffic. Returned in notification events.",
        alias="applicationId",
    )
    entity_id: Optional[StrictStr] = Field(
        default=None,
        description="Required for entity use in a send request for outbound traffic. Returned in notification events.",
        alias="entityId",
    )
    __properties: ClassVar[List[str]] = [
        "domainName",
        "dkimKeyLength",
        "targetedDailyTraffic",
        "applicationId",
        "entityId",
    ]

    @field_validator("dkim_key_length")
    def dkim_key_length_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1024, 2048]):
            raise ValueError("must be one of enum values (1024, 2048)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailAddDomainRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailAddDomainRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "domainName": obj.get("domainName"),
                "dkimKeyLength": (
                    obj.get("dkimKeyLength")
                    if obj.get("dkimKeyLength") is not None
                    else 2048
                ),
                "targetedDailyTraffic": obj.get("targetedDailyTraffic"),
                "applicationId": obj.get("applicationId"),
                "entityId": obj.get("entityId"),
            }
        )
        return _obj
