# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.email_to_destination import EmailToDestination
from typing import Optional, Set
from typing_extensions import Self


class EmailGroupDestination(BaseModel):
    """
    An array of destination objects for where messages are being sent. A valid destination is required.
    """  # noqa: E501

    to: Optional[List[EmailToDestination]] = None
    cc: Optional[List[EmailToDestination]] = Field(
        default=None,
        description="CC recipient email address.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.",
    )
    bcc: Optional[List[EmailToDestination]] = Field(
        default=None,
        description="BCC recipient email address.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.",
    )
    reply_to: Optional[StrictStr] = Field(
        default=None,
        description="Email address to which recipients of the email can reply.",
        alias="replyTo",
    )
    preserve_recipients: Optional[StrictBool] = Field(
        default=False,
        description="When this option is set to `true`, all recipients in the `to` field will be able to see the entire list of recipients who received the email, and the response will include a single `messageId`. If the option is set to `false` , each recipient will only see their own email address, and the response will provide a unique `messageId` for each individual recipient.",
        alias="preserveRecipients",
    )
    __properties: ClassVar[List[str]] = [
        "to",
        "cc",
        "bcc",
        "replyTo",
        "preserveRecipients",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailGroupDestination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in to (list)
        _items = []
        if self.to:
            for _item_to in self.to:
                if _item_to:
                    _items.append(_item_to.to_dict())
            _dict["to"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cc (list)
        _items = []
        if self.cc:
            for _item_cc in self.cc:
                if _item_cc:
                    _items.append(_item_cc.to_dict())
            _dict["cc"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bcc (list)
        _items = []
        if self.bcc:
            for _item_bcc in self.bcc:
                if _item_bcc:
                    _items.append(_item_bcc.to_dict())
            _dict["bcc"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailGroupDestination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "to": (
                    [EmailToDestination.from_dict(_item) for _item in obj["to"]]
                    if obj.get("to") is not None
                    else None
                ),
                "cc": (
                    [EmailToDestination.from_dict(_item) for _item in obj["cc"]]
                    if obj.get("cc") is not None
                    else None
                ),
                "bcc": (
                    [EmailToDestination.from_dict(_item) for _item in obj["bcc"]]
                    if obj.get("bcc") is not None
                    else None
                ),
                "replyTo": obj.get("replyTo"),
                "preserveRecipients": (
                    obj.get("preserveRecipients")
                    if obj.get("preserveRecipients") is not None
                    else False
                ),
            }
        )
        return _obj
