# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.delivery_time_window import DeliveryTimeWindow
from infobip_api_client.models.platform import Platform
from infobip_api_client.models.validity_period import ValidityPeriod
from typing import Optional, Set
from typing_extensions import Self


class EmailMessageOptions(BaseModel):
    """
    Message options.
    """  # noqa: E501

    platform: Optional[Platform] = None
    validity_period: Optional[ValidityPeriod] = Field(
        default=None, alias="validityPeriod"
    )
    delivery_time_window: Optional[DeliveryTimeWindow] = Field(
        default=None, alias="deliveryTimeWindow"
    )
    campaign_reference_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=255)]
    ] = Field(
        default=None,
        description="ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns per sending channel.",
        alias="campaignReferenceId",
    )
    __properties: ClassVar[List[str]] = [
        "platform",
        "validityPeriod",
        "deliveryTimeWindow",
        "campaignReferenceId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailMessageOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validity_period
        if self.validity_period:
            _dict["validityPeriod"] = self.validity_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_time_window
        if self.delivery_time_window:
            _dict["deliveryTimeWindow"] = self.delivery_time_window.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailMessageOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "validityPeriod": (
                    ValidityPeriod.from_dict(obj["validityPeriod"])
                    if obj.get("validityPeriod") is not None
                    else None
                ),
                "deliveryTimeWindow": (
                    DeliveryTimeWindow.from_dict(obj["deliveryTimeWindow"])
                    if obj.get("deliveryTimeWindow") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
            }
        )
        return _obj
