# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class EmailSendMimeRequestSchema(BaseModel):
    """
    EmailSendMimeRequestSchema
    """  # noqa: E501

    message_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent to a recipient.",
        alias="messageId",
    )
    bulk_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the sent bulk. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)\")",
        alias="bulkId",
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="The email address specified in this field takes precedence over the From header in the MIME message. If you leave this field empty, the From address in the MIME message will be used instead. If you provide both values and they are different, their domains must match at the organizational level; otherwise, the request will be rejected. ",
        alias="from",
    )
    destinations: Optional[List[Annotated[str, Field(strict=True)]]] = Field(
        default=None,
        description="A list of recipient email addresses. <br/> The email addresses specified in this field takes precedence over the To, CC, and BCC headers in the MIME message. Only the addresses in this list will receive the final email. If you leave this field empty, To, CC, and BCC headers in the MIME message will be used instead. <br/> Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.",
    )
    mime_message: StrictStr = Field(
        description="This field accepts a complete email message serialized in the MIME format, conforming to RFC 5322 and MIME-related standards (RFCs 2045–2047, RFC 2183). The MIME message must be correctly constructed per the following requirements as if it were being sent via traditional SMTP. The entire MIME message (including headers and body) must be `base64-encoded` before being sent. <br/><br/>  When using this field, these are the requirements: <br/> **-** The message must consist of a set of header fields, followed by a blank line (CRLF), and then the message body <br/> **-** All required and optional fields must be properly formatted with header-name, colon, and header-value <br/> **-** If any MIME part contains non-7-bit-ASCII data (e.g., UTF-8 text, binaries), that part must be encoded <br/> **-** If your message uses multipart content (attachments, alternative bodies, etc.), each MIME part must contain `Content-Type` header. For encoded parts, include `Content-Transfer-Encoding`. For attachments, include a valid `Content-Disposition`. <br/><br/> We also support specifying additional headers in your MIME message, such as `List-Unsubscribe`, `List-Unsubscribe-Post`, `In-Reply-To`, `References` and `Message-ID`. ",
        alias="mimeMessage",
    )
    intermediate_report: Optional[StrictBool] = Field(
        default=None,
        description="The real-time Intermediate delivery report that will be sent on your callback server.",
        alias="intermediateReport",
    )
    notify_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the Delivery report will be sent.",
        alias="notifyUrl",
    )
    notify_content_type: Optional[StrictStr] = Field(
        default=None,
        description="Preferred Delivery report content type. Can be `application/json` or `application/xml`.",
        alias="notifyContentType",
    )
    callback_data: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="Additional client data that will be sent on the notifyUrl.",
        alias="callbackData",
    )
    tracking_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/email-over-api/tracking-notifications) for details.",
        alias="trackingUrl",
    )
    client_priority: Optional[StrictStr] = Field(
        default="STANDARD",
        description="Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default. ",
        alias="clientPriority",
    )
    application_id: Optional[StrictStr] = Field(
        default=None,
        description="Required for application use in a send request for outbound traffic. Returned in notification events.",
        alias="applicationId",
    )
    entity_id: Optional[StrictStr] = Field(
        default=None,
        description="Required for entity use in a send request for outbound traffic. Returned in notification events.",
        alias="entityId",
    )
    __properties: ClassVar[List[str]] = [
        "messageId",
        "bulkId",
        "from",
        "destinations",
        "mimeMessage",
        "intermediateReport",
        "notifyUrl",
        "notifyContentType",
        "callbackData",
        "trackingUrl",
        "clientPriority",
        "applicationId",
        "entityId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailSendMimeRequestSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailSendMimeRequestSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "messageId": obj.get("messageId"),
                "bulkId": obj.get("bulkId"),
                "from": obj.get("from"),
                "destinations": obj.get("destinations"),
                "mimeMessage": obj.get("mimeMessage"),
                "intermediateReport": obj.get("intermediateReport"),
                "notifyUrl": obj.get("notifyUrl"),
                "notifyContentType": obj.get("notifyContentType"),
                "callbackData": obj.get("callbackData"),
                "trackingUrl": obj.get("trackingUrl"),
                "clientPriority": (
                    obj.get("clientPriority")
                    if obj.get("clientPriority") is not None
                    else "STANDARD"
                ),
                "applicationId": obj.get("applicationId"),
                "entityId": obj.get("entityId"),
            }
        )
        return _obj
