# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.email_attachment import EmailAttachment
from typing import Optional, Set
from typing_extensions import Self


class EmailTemplate(BaseModel):
    """
    EmailTemplate
    """  # noqa: E501

    id: StrictInt = Field(description="Unique identifier of the email template.")
    name: Optional[StrictStr] = Field(
        default=None, description="Name of the email template."
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="Email address with optional sender name.",
        alias="from",
    )
    reply_to: Optional[StrictStr] = Field(
        default=None,
        description="Email address to which recipients of the email can reply.",
        alias="replyTo",
    )
    subject: Optional[StrictStr] = Field(
        default=None, description="Subject of the email template."
    )
    preheader: Optional[StrictStr] = Field(
        default=None, description="Preheader of the email template."
    )
    html: StrictStr = Field(description="HTML content of the email template.")
    is_html_editable: StrictBool = Field(
        description="Flag indicating if the HTML content is editable.",
        alias="isHtmlEditable",
    )
    attachments: Optional[List[EmailAttachment]] = Field(
        default=None, description="List of attachments."
    )
    landing_page_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique identifier of the landing page.",
        alias="landingPageId",
    )
    image_preview_url: Optional[StrictStr] = Field(
        default=None, description="URL of the image preview.", alias="imagePreviewUrl"
    )
    created_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the email template was created. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.",
        alias="createdAt",
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the email template was last updated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.",
        alias="updatedAt",
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "from",
        "replyTo",
        "subject",
        "preheader",
        "html",
        "isHtmlEditable",
        "attachments",
        "landingPageId",
        "imagePreviewUrl",
        "createdAt",
        "updatedAt",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict["attachments"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "from": obj.get("from"),
                "replyTo": obj.get("replyTo"),
                "subject": obj.get("subject"),
                "preheader": obj.get("preheader"),
                "html": obj.get("html"),
                "isHtmlEditable": obj.get("isHtmlEditable"),
                "attachments": (
                    [EmailAttachment.from_dict(_item) for _item in obj["attachments"]]
                    if obj.get("attachments") is not None
                    else None
                ),
                "landingPageId": obj.get("landingPageId"),
                "imagePreviewUrl": obj.get("imagePreviewUrl"),
                "createdAt": obj.get("createdAt"),
                "updatedAt": obj.get("updatedAt"),
            }
        )
        return _obj
