# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class EmailToDestination(BaseModel):
    """
    BCC recipient email address.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
    """  # noqa: E501

    destination: StrictStr = Field(
        description="Email address of the recipient in a form of `john.smith@somecompany.com`  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field. "
    )
    message_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=200)]
    ] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent to a recipient.",
        alias="messageId",
    )
    placeholders: Optional[StrictStr] = Field(
        default=None,
        description='As optional feature, a specific placeholder can be defined whose value will apply only for this destination. Value should be defined as: `{"name": "John"}` ',
    )
    __properties: ClassVar[List[str]] = ["destination", "messageId", "placeholders"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailToDestination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailToDestination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "destination": obj.get("destination"),
                "messageId": obj.get("messageId"),
                "placeholders": obj.get("placeholders"),
            }
        )
        return _obj
