# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class EmailUrlOptions(BaseModel):
    """
    EmailUrlOptions
    """  # noqa: E501

    track: Optional[StrictBool] = Field(
        default=True,
        description="Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`.",
    )
    track_opens: Optional[StrictBool] = Field(
        default=None,
        description="This parameter enables or disables track open feature.",
        alias="trackOpens",
    )
    track_clicks: Optional[StrictBool] = Field(
        default=None,
        description="This parameter enables or disables track click feature.",
        alias="trackClicks",
    )
    tracking_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details.",
        alias="trackingUrl",
    )
    tracking_pixel_position: Optional[StrictStr] = Field(
        default="TOP",
        description="This parameter specifies the position of the open tracking pixel within the email content. Allowed values are `TOP` and `BOTTOM`. If no value is provided, the default is `TOP`.",
        alias="trackingPixelPosition",
    )
    __properties: ClassVar[List[str]] = [
        "track",
        "trackOpens",
        "trackClicks",
        "trackingUrl",
        "trackingPixelPosition",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailUrlOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailUrlOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "track": obj.get("track") if obj.get("track") is not None else True,
                "trackOpens": obj.get("trackOpens"),
                "trackClicks": obj.get("trackClicks"),
                "trackingUrl": obj.get("trackingUrl"),
                "trackingPixelPosition": (
                    obj.get("trackingPixelPosition")
                    if obj.get("trackingPixelPosition") is not None
                    else "TOP"
                ),
            }
        )
        return _obj
