# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
import pprint
import re  # noqa: F401
from pydantic import (
    BaseModel,
    ValidationError,
    field_validator,
)
from typing import Optional
from infobip_api_client.models.flow_custom_bad_request_response import (
    FlowCustomBadRequestResponse,
)
from infobip_api_client.models.flow_old_exception_response import (
    FlowOldExceptionResponse,
)
from typing import Union, Any, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Self

FLOWEXCEPTIONRESPONSE_ANY_OF_SCHEMAS = [
    "FlowCustomBadRequestResponse",
    "FlowOldExceptionResponse",
]


class FlowExceptionResponse(BaseModel):
    """
    FlowExceptionResponse
    """

    # data type: FlowCustomBadRequestResponse
    anyof_schema_1_validator: Optional[FlowCustomBadRequestResponse] = None
    # data type: FlowOldExceptionResponse
    anyof_schema_2_validator: Optional[FlowOldExceptionResponse] = None
    if TYPE_CHECKING:
        actual_instance: Optional[
            Union[FlowCustomBadRequestResponse, FlowOldExceptionResponse]
        ] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = {
        "FlowCustomBadRequestResponse",
        "FlowOldExceptionResponse",
    }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_anyof(cls, v):
        instance = FlowExceptionResponse.model_construct()
        error_messages = []
        # validate data type: FlowCustomBadRequestResponse
        if not isinstance(v, FlowCustomBadRequestResponse):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `FlowCustomBadRequestResponse`"
            )
        else:
            return v

        # validate data type: FlowOldExceptionResponse
        if not isinstance(v, FlowOldExceptionResponse):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `FlowOldExceptionResponse`"
            )
        else:
            return v

        if error_messages:
            # no match
            raise ValueError(
                "No match found when setting the actual_instance in FlowExceptionResponse with anyOf schemas: FlowCustomBadRequestResponse, FlowOldExceptionResponse. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[FlowCustomBadRequestResponse] = None
        try:
            instance.actual_instance = FlowCustomBadRequestResponse.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[FlowOldExceptionResponse] = None
        try:
            instance.actual_instance = FlowOldExceptionResponse.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into FlowExceptionResponse with anyOf schemas: FlowCustomBadRequestResponse, FlowOldExceptionResponse. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[Dict[str, Any], FlowCustomBadRequestResponse, FlowOldExceptionResponse]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
