# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class FlowOldExceptionResponse(BaseModel):
    """
    Response error codes  <table> <tr><th>Error</th><th>ErrorCode</th><th>HTTP status</th></tr> <tr><td>Bad request</td><td>40001</td><td>400</td></tr> <tr><td>Duplicate person</td><td>40002</td><td>400</td></tr> <tr><td>Person manipulation failed</td><td>40003</td><td>400</td></tr> <tr><td>Person already in flow</td><td>40004</td><td>400</td></tr> <tr><td>Flow inactive</td><td>40005</td><td>400</td></tr> <tr><td>Person is not in the flow</td><td>40006</td><td>400</td></tr> <tr><td>Flow not found</td><td>40401</td><td>404</td></tr> <tr><td>Person not found</td><td>40402</td><td>404</td></tr> <tr><td>Action not found</td><td>40403</td><td>404</td></tr> <tr><td>Internal server error</td><td>50001</td><td>500</td></tr> </table>
    """  # noqa: E501

    error_code: Optional[StrictInt] = Field(default=None, alias="errorCode")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    __properties: ClassVar[List[str]] = ["errorCode", "errorMessage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowOldExceptionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowOldExceptionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {"errorCode": obj.get("errorCode"), "errorMessage": obj.get("errorMessage")}
        )
        return _obj
