# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.flow_gender import FlowGender
from infobip_api_client.models.flow_integrations import FlowIntegrations
from infobip_api_client.models.flow_origin import FlowOrigin
from infobip_api_client.models.flow_person_contacts import FlowPersonContacts
from infobip_api_client.models.flow_type import FlowType
from typing import Optional, Set
from typing_extensions import Self


class FlowPerson(BaseModel):
    """
    Person attributes. In case a person with either the specified <code>externalId</code> or <code>contactInformation</code> already exists in the People, the persons will be automatically merged. See <a href=\"https://www.infobip.com/docs/api/customer-engagement/moments/add-flow-participants\" target=\"_blank\">endpoint description</a> for more info.
    """  # noqa: E501

    created_at: Optional[StrictStr] = Field(
        default=None,
        description="Date and time of creation. Has the following format: yyyy-MM-dd'T'HH:mm:ss.",
        alias="createdAt",
    )
    modified_at: Optional[StrictStr] = Field(
        default=None,
        description="Date and time of last modification. Has the following format: yyyy-MM-dd'T'HH:mm:ss.",
        alias="modifiedAt",
    )
    id: Optional[StrictInt] = Field(
        default=None, description="Unique id of the entity."
    )
    external_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique ID for a person from your or another external system, 256 characters max.",
        alias="externalId",
    )
    first_name: Optional[StrictStr] = Field(
        default=None,
        description="Person's first name, 255 characters max.",
        alias="firstName",
    )
    last_name: Optional[StrictStr] = Field(
        default=None,
        description="Person's last name, 255 characters max.",
        alias="lastName",
    )
    type: Optional[FlowType] = None
    address: Optional[StrictStr] = Field(
        default=None, description="Person's title, 50 characters max."
    )
    city: Optional[StrictStr] = Field(
        default=None, description="Person's city, 50 characters max."
    )
    country: Optional[StrictStr] = Field(
        default=None, description="Person's country, 50 characters max."
    )
    gender: Optional[FlowGender] = None
    birth_date: Optional[StrictStr] = Field(
        default=None,
        description="Person's date of birth, format `YYYY-MM-DD`.",
        alias="birthDate",
    )
    middle_name: Optional[StrictStr] = Field(
        default=None,
        description="Person's middle name, 50 characters max.",
        alias="middleName",
    )
    preferred_language: Optional[StrictStr] = Field(
        default=None,
        description="Person's preferred language. Must be in two letter ISO (xx) or language-region BCP-47 (xx-YY) format.",
        alias="preferredLanguage",
    )
    profile_picture: Optional[StrictStr] = Field(
        default=None,
        description="URL for the person's profile picture, 2083 characters max.",
        alias="profilePicture",
    )
    origin: Optional[FlowOrigin] = None
    modified_from: Optional[FlowOrigin] = Field(default=None, alias="modifiedFrom")
    tags: Optional[List[StrictStr]] = Field(
        default=None, description="List of tags that this person has."
    )
    custom_attributes: Optional[Dict[str, Any]] = Field(
        default=None,
        description="List of custom attributes for the person, 4096 characters max per value.",
        alias="customAttributes",
    )
    contact_information: Optional[FlowPersonContacts] = Field(
        default=None, alias="contactInformation"
    )
    integrations: Optional[FlowIntegrations] = None
    computed_attributes: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Person's computed attributes grouped by type.",
        alias="computedAttributes",
    )
    __properties: ClassVar[List[str]] = [
        "createdAt",
        "modifiedAt",
        "id",
        "externalId",
        "firstName",
        "lastName",
        "type",
        "address",
        "city",
        "country",
        "gender",
        "birthDate",
        "middleName",
        "preferredLanguage",
        "profilePicture",
        "origin",
        "modifiedFrom",
        "tags",
        "customAttributes",
        "contactInformation",
        "integrations",
        "computedAttributes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowPerson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of contact_information
        if self.contact_information:
            _dict["contactInformation"] = self.contact_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integrations
        if self.integrations:
            _dict["integrations"] = self.integrations.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowPerson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "createdAt": obj.get("createdAt"),
                "modifiedAt": obj.get("modifiedAt"),
                "id": obj.get("id"),
                "externalId": obj.get("externalId"),
                "firstName": obj.get("firstName"),
                "lastName": obj.get("lastName"),
                "type": obj.get("type"),
                "address": obj.get("address"),
                "city": obj.get("city"),
                "country": obj.get("country"),
                "gender": obj.get("gender"),
                "birthDate": obj.get("birthDate"),
                "middleName": obj.get("middleName"),
                "preferredLanguage": obj.get("preferredLanguage"),
                "profilePicture": obj.get("profilePicture"),
                "origin": obj.get("origin"),
                "modifiedFrom": obj.get("modifiedFrom"),
                "tags": obj.get("tags"),
                "customAttributes": obj.get("customAttributes"),
                "contactInformation": (
                    FlowPersonContacts.from_dict(obj["contactInformation"])
                    if obj.get("contactInformation") is not None
                    else None
                ),
                "integrations": (
                    FlowIntegrations.from_dict(obj["integrations"])
                    if obj.get("integrations") is not None
                    else None
                ),
                "computedAttributes": obj.get("computedAttributes"),
            }
        )
        return _obj
