# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class MessageStatus(BaseModel):
    """
    Indicates the message status.
    """  # noqa: E501

    group_name: Optional[StrictStr] = Field(
        default=None, description="Group name for the status.", alias="groupName"
    )
    id: Optional[StrictInt] = Field(default=None, description="Status ID.")
    group_id: Optional[StrictInt] = Field(
        default=None, description="Status group ID.", alias="groupId"
    )
    name: Optional[StrictStr] = Field(default=None, description="Status name.")
    action: Optional[StrictStr] = Field(
        default=None, description="Action that should be taken to fix the error."
    )
    description: Optional[StrictStr] = Field(
        default=None, description="Human-readable description of the status."
    )
    __properties: ClassVar[List[str]] = [
        "groupName",
        "id",
        "groupId",
        "name",
        "action",
        "description",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessageStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessageStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "groupName": obj.get("groupName"),
                "id": obj.get("id"),
                "groupId": obj.get("groupId"),
                "name": obj.get("name"),
                "action": obj.get("action"),
                "description": obj.get("description"),
            }
        )
        return _obj
