# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_channel_destination import (
    MessagesApiChannelDestination,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiChannelsDestination(BaseModel):
    """
    Represents a destination which can be specified by a `channel`. **It is required for a message failover**.
    """  # noqa: E501

    message_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=200)]
    ] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent. If failover is defined, then it will override values provided in `byChannel` array and be applied to each message in failover flow.",
        alias="messageId",
    )
    by_channel: List[MessagesApiChannelDestination] = Field(
        description="An array of substitute destinations, each associated with a specific `channel`. Only one substitute destination is allowed per `channel`. A substitute destination must be provided for the main `channel` defined in the `message`.",
        alias="byChannel",
    )
    __properties: ClassVar[List[str]] = ["messageId", "byChannel"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiChannelsDestination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in by_channel (list)
        _items = []
        if self.by_channel:
            for _item_by_channel in self.by_channel:
                if _item_by_channel:
                    _items.append(_item_by_channel.to_dict())
            _dict["byChannel"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiChannelsDestination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "messageId": obj.get("messageId"),
                "byChannel": (
                    [
                        MessagesApiChannelDestination.from_dict(_item)
                        for _item in obj["byChannel"]
                    ]
                    if obj.get("byChannel") is not None
                    else None
                ),
            }
        )
        return _obj
