# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_message_apple_pay_payment_configuration_contact_field import (
    MessagesApiMessageApplePayPaymentConfigurationContactField,
)
from infobip_api_client.models.messages_api_message_apple_pay_payment_configuration_merchant_capability import (
    MessagesApiMessageApplePayPaymentConfigurationMerchantCapability,
)
from infobip_api_client.models.messages_api_message_apple_pay_payment_configuration_network import (
    MessagesApiMessageApplePayPaymentConfigurationNetwork,
)
from infobip_api_client.models.messages_api_message_payment_configuration import (
    MessagesApiMessagePaymentConfiguration,
)
from infobip_api_client.models.messages_api_message_payment_configuration_type import (
    MessagesApiMessagePaymentConfigurationType,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageApplePayPaymentConfiguration(
    MessagesApiMessagePaymentConfiguration
):
    """
    MessagesApiMessageApplePayPaymentConfiguration
    """  # noqa: E501

    merchant_domain: Optional[StrictStr] = Field(
        default=None,
        description="The domain of the merchant's website.",
        alias="merchantDomain",
    )
    merchant_display_name: Optional[StrictStr] = Field(
        default=None,
        description="The merchant's display name.",
        alias="merchantDisplayName",
    )
    merchant_payment_gateway_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL of the merchant's payment gateway. This is the URL that Apple Pay uses to process payments.",
        alias="merchantPaymentGatewayUrl",
    )
    merchant_country_code: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="The two-letter ISO 3166 merchant’s country code.",
        alias="merchantCountryCode",
    )
    currency_code: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="The three-letter ISO 4217 currency code for the payment.",
        alias="currencyCode",
    )
    merchant_capabilities: Optional[
        List[MessagesApiMessageApplePayPaymentConfigurationMerchantCapability]
    ] = Field(
        default=None,
        description="An array of payment capabilities supported by the merchant. The array must include 3DS.",
        alias="merchantCapabilities",
    )
    supported_networks: Optional[
        List[MessagesApiMessageApplePayPaymentConfigurationNetwork]
    ] = Field(
        default=None,
        description="An array of payment networks supported by the merchant. The array must include one or more of the following values: AMEX, DISCOVER, MASTERCARD, PRIVATE_LABEL or VISA.",
        alias="supportedNetworks",
    )
    required_billing_fields: Optional[
        List[MessagesApiMessageApplePayPaymentConfigurationContactField]
    ] = Field(
        default=None,
        description="The list of the customer's required billing information needed to process the transaction.",
        alias="requiredBillingFields",
    )
    required_shipping_fields: Optional[
        List[MessagesApiMessageApplePayPaymentConfigurationContactField]
    ] = Field(
        default=None,
        description="The list of shipping or contact information required from the customer to fulfill the order.",
        alias="requiredShippingFields",
    )
    payment_method_update_url: Optional[StrictStr] = Field(
        default=None,
        description="Called by Apple Pay when the user changes the payment method.",
        alias="paymentMethodUpdateUrl",
    )
    shipping_contact_update_url: Optional[StrictStr] = Field(
        default=None,
        description="Called by Apple Pay when the user changes their shipping address information.",
        alias="shippingContactUpdateUrl",
    )
    shipping_method_update_url: Optional[StrictStr] = Field(
        default=None,
        description="Called by Apple Pay when the user changes the shipping method.",
        alias="shippingMethodUpdateUrl",
    )
    order_tracking_url: Optional[StrictStr] = Field(
        default=None,
        description="Called by Apple Pay after completing the order provides you with an opportunity to update the order information in your system.",
        alias="orderTrackingUrl",
    )
    fallback_url: Optional[StrictStr] = Field(
        default=None,
        description="A URL that opens in a web browser so the user can complete the purchase if their device is unable to make payments using Apple Pay.",
        alias="fallbackUrl",
    )
    type: MessagesApiMessagePaymentConfigurationType = "APPLE_PAY"
    __properties: ClassVar[List[str]] = [
        "type",
        "merchantDomain",
        "merchantDisplayName",
        "merchantPaymentGatewayUrl",
        "merchantCountryCode",
        "currencyCode",
        "merchantCapabilities",
        "supportedNetworks",
        "requiredBillingFields",
        "requiredShippingFields",
        "paymentMethodUpdateUrl",
        "shippingContactUpdateUrl",
        "shippingMethodUpdateUrl",
        "orderTrackingUrl",
        "fallbackUrl",
    ]

    @field_validator("merchant_country_code")
    def merchant_country_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[A-Z]{2}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{2}$/")
        return value

    @field_validator("currency_code")
    def currency_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[A-Z]{3}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageApplePayPaymentConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageApplePayPaymentConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "merchantDomain": obj.get("merchantDomain"),
                "merchantDisplayName": obj.get("merchantDisplayName"),
                "merchantPaymentGatewayUrl": obj.get("merchantPaymentGatewayUrl"),
                "merchantCountryCode": obj.get("merchantCountryCode"),
                "currencyCode": obj.get("currencyCode"),
                "merchantCapabilities": obj.get("merchantCapabilities"),
                "supportedNetworks": obj.get("supportedNetworks"),
                "requiredBillingFields": obj.get("requiredBillingFields"),
                "requiredShippingFields": obj.get("requiredShippingFields"),
                "paymentMethodUpdateUrl": obj.get("paymentMethodUpdateUrl"),
                "shippingContactUpdateUrl": obj.get("shippingContactUpdateUrl"),
                "shippingMethodUpdateUrl": obj.get("shippingMethodUpdateUrl"),
                "orderTrackingUrl": obj.get("orderTrackingUrl"),
                "fallbackUrl": obj.get("fallbackUrl"),
            }
        )
        return _obj
