# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Union
from infobip_api_client.models.messages_api_message_body_type import (
    MessagesApiMessageBodyType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.messages_api_message_authentication_request_body import (
        MessagesApiMessageAuthenticationRequestBody,
    )
    from infobip_api_client.models.messages_api_message_carousel_body import (
        MessagesApiMessageCarouselBody,
    )
    from infobip_api_client.models.messages_api_message_contact_body import (
        MessagesApiMessageContactBody,
    )
    from infobip_api_client.models.messages_api_message_document_body import (
        MessagesApiMessageDocumentBody,
    )
    from infobip_api_client.models.messages_api_message_flow_body import (
        MessagesApiMessageFlowBody,
    )
    from infobip_api_client.models.messages_api_message_form_body import (
        MessagesApiMessageFormBody,
    )
    from infobip_api_client.models.messages_api_message_image_body import (
        MessagesApiMessageImageBody,
    )
    from infobip_api_client.models.messages_api_message_list_body import (
        MessagesApiMessageListBody,
    )
    from infobip_api_client.models.messages_api_message_location_body import (
        MessagesApiMessageLocationBody,
    )
    from infobip_api_client.models.messages_api_message_mixed_body import (
        MessagesApiMessageMixedBody,
    )
    from infobip_api_client.models.messages_api_message_order_request_body import (
        MessagesApiMessageOrderRequestBody,
    )
    from infobip_api_client.models.messages_api_message_order_status_body import (
        MessagesApiMessageOrderStatusBody,
    )
    from infobip_api_client.models.messages_api_message_product_body import (
        MessagesApiMessageProductBody,
    )
    from infobip_api_client.models.messages_api_message_rich_link_body import (
        MessagesApiMessageRichLinkBody,
    )
    from infobip_api_client.models.messages_api_message_sticker_body import (
        MessagesApiMessageStickerBody,
    )
    from infobip_api_client.models.messages_api_message_text_body import (
        MessagesApiMessageTextBody,
    )
    from infobip_api_client.models.messages_api_message_time_picker_body import (
        MessagesApiMessageTimePickerBody,
    )
    from infobip_api_client.models.messages_api_message_video_body import (
        MessagesApiMessageVideoBody,
    )


class MessagesApiMessageBody(BaseModel):
    """
    Body of the message.
    """  # noqa: E501

    type: MessagesApiMessageBodyType
    __properties: ClassVar[List[str]] = ["type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "AUTHENTICATION_REQUEST": "MessagesApiMessageAuthenticationRequestBody",
        "CAROUSEL": "MessagesApiMessageCarouselBody",
        "CONTACT": "MessagesApiMessageContactBody",
        "DOCUMENT": "MessagesApiMessageDocumentBody",
        "FLOW": "MessagesApiMessageFlowBody",
        "FORM": "MessagesApiMessageFormBody",
        "IMAGE": "MessagesApiMessageImageBody",
        "LIST": "MessagesApiMessageListBody",
        "LOCATION": "MessagesApiMessageLocationBody",
        "MIXED": "MessagesApiMessageMixedBody",
        "ORDER_REQUEST": "MessagesApiMessageOrderRequestBody",
        "ORDER_STATUS": "MessagesApiMessageOrderStatusBody",
        "PRODUCT": "MessagesApiMessageProductBody",
        "RICH_LINK": "MessagesApiMessageRichLinkBody",
        "STICKER": "MessagesApiMessageStickerBody",
        "TEXT": "MessagesApiMessageTextBody",
        "TIME_PICKER": "MessagesApiMessageTimePickerBody",
        "VIDEO": "MessagesApiMessageVideoBody",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            MessagesApiMessageAuthenticationRequestBody,
            MessagesApiMessageCarouselBody,
            MessagesApiMessageContactBody,
            MessagesApiMessageDocumentBody,
            MessagesApiMessageFlowBody,
            MessagesApiMessageFormBody,
            MessagesApiMessageImageBody,
            MessagesApiMessageListBody,
            MessagesApiMessageLocationBody,
            MessagesApiMessageMixedBody,
            MessagesApiMessageOrderRequestBody,
            MessagesApiMessageOrderStatusBody,
            MessagesApiMessageProductBody,
            MessagesApiMessageRichLinkBody,
            MessagesApiMessageStickerBody,
            MessagesApiMessageTextBody,
            MessagesApiMessageTimePickerBody,
            MessagesApiMessageVideoBody,
        ]
    ]:
        """Create an instance of MessagesApiMessageBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            MessagesApiMessageAuthenticationRequestBody,
            MessagesApiMessageCarouselBody,
            MessagesApiMessageContactBody,
            MessagesApiMessageDocumentBody,
            MessagesApiMessageFlowBody,
            MessagesApiMessageFormBody,
            MessagesApiMessageImageBody,
            MessagesApiMessageListBody,
            MessagesApiMessageLocationBody,
            MessagesApiMessageMixedBody,
            MessagesApiMessageOrderRequestBody,
            MessagesApiMessageOrderStatusBody,
            MessagesApiMessageProductBody,
            MessagesApiMessageRichLinkBody,
            MessagesApiMessageStickerBody,
            MessagesApiMessageTextBody,
            MessagesApiMessageTimePickerBody,
            MessagesApiMessageVideoBody,
        ]
    ]:
        """Create an instance of MessagesApiMessageBody from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MessagesApiMessageAuthenticationRequestBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_authentication_request_body"
            ).MessagesApiMessageAuthenticationRequestBody.from_dict(obj)
        if object_type == "MessagesApiMessageCarouselBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_carousel_body"
            ).MessagesApiMessageCarouselBody.from_dict(obj)
        if object_type == "MessagesApiMessageContactBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_contact_body"
            ).MessagesApiMessageContactBody.from_dict(obj)
        if object_type == "MessagesApiMessageDocumentBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_document_body"
            ).MessagesApiMessageDocumentBody.from_dict(obj)
        if object_type == "MessagesApiMessageFlowBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_flow_body"
            ).MessagesApiMessageFlowBody.from_dict(obj)
        if object_type == "MessagesApiMessageFormBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_form_body"
            ).MessagesApiMessageFormBody.from_dict(obj)
        if object_type == "MessagesApiMessageImageBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_image_body"
            ).MessagesApiMessageImageBody.from_dict(obj)
        if object_type == "MessagesApiMessageListBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_list_body"
            ).MessagesApiMessageListBody.from_dict(obj)
        if object_type == "MessagesApiMessageLocationBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_location_body"
            ).MessagesApiMessageLocationBody.from_dict(obj)
        if object_type == "MessagesApiMessageMixedBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_mixed_body"
            ).MessagesApiMessageMixedBody.from_dict(obj)
        if object_type == "MessagesApiMessageOrderRequestBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_order_request_body"
            ).MessagesApiMessageOrderRequestBody.from_dict(obj)
        if object_type == "MessagesApiMessageOrderStatusBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_order_status_body"
            ).MessagesApiMessageOrderStatusBody.from_dict(obj)
        if object_type == "MessagesApiMessageProductBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_product_body"
            ).MessagesApiMessageProductBody.from_dict(obj)
        if object_type == "MessagesApiMessageRichLinkBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_rich_link_body"
            ).MessagesApiMessageRichLinkBody.from_dict(obj)
        if object_type == "MessagesApiMessageStickerBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_sticker_body"
            ).MessagesApiMessageStickerBody.from_dict(obj)
        if object_type == "MessagesApiMessageTextBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_text_body"
            ).MessagesApiMessageTextBody.from_dict(obj)
        if object_type == "MessagesApiMessageTimePickerBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_time_picker_body"
            ).MessagesApiMessageTimePickerBody.from_dict(obj)
        if object_type == "MessagesApiMessageVideoBody":
            return import_module(
                "infobip_api_client.models.messages_api_message_video_body"
            ).MessagesApiMessageVideoBody.from_dict(obj)

        raise ValueError(
            "MessagesApiMessageBody failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
