# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_message_card_options import (
    MessagesApiMessageCardOptions,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageCarouselCardBody(BaseModel):
    """
    Body of a card.
    """  # noqa: E501

    title: Optional[StrictStr] = Field(default=None, description="Title of the card.")
    text: Optional[StrictStr] = Field(default=None, description="Text to be sent.")
    url: Optional[StrictStr] = Field(
        default=None,
        description="URL of the card's media. It can be image or video. When you provide it with `isVideo=true` then it will be mapped as a video, otherwise - as an image.",
    )
    is_video: Optional[StrictBool] = Field(
        default=False,
        description="Indicates if provided `url` is a video.",
        alias="isVideo",
    )
    thumbnail_url: Optional[StrictStr] = Field(
        default=None,
        description="URL of the thumbnail image. If you add this, then we use as thumbnail image for video you provided in `url`. Applicable only when `isVideo=true`.",
        alias="thumbnailUrl",
    )
    card_options: Optional[MessagesApiMessageCardOptions] = Field(
        default=None, alias="cardOptions"
    )
    __properties: ClassVar[List[str]] = [
        "title",
        "text",
        "url",
        "isVideo",
        "thumbnailUrl",
        "cardOptions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageCarouselCardBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of card_options
        if self.card_options:
            _dict["cardOptions"] = self.card_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageCarouselCardBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "title": obj.get("title"),
                "text": obj.get("text"),
                "url": obj.get("url"),
                "isVideo": (
                    obj.get("isVideo") if obj.get("isVideo") is not None else False
                ),
                "thumbnailUrl": obj.get("thumbnailUrl"),
                "cardOptions": (
                    MessagesApiMessageCardOptions.from_dict(obj["cardOptions"])
                    if obj.get("cardOptions") is not None
                    else None
                ),
            }
        )
        return _obj
