# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_message_body import MessagesApiMessageBody
from infobip_api_client.models.messages_api_message_button import (
    MessagesApiMessageButton,
)
from infobip_api_client.models.messages_api_message_confirmation_body import (
    MessagesApiMessageConfirmationBody,
)
from infobip_api_client.models.messages_api_message_footer import (
    MessagesApiMessageFooter,
)
from infobip_api_client.models.messages_api_message_header import (
    MessagesApiMessageHeader,
)
from infobip_api_client.models.messages_api_message_sender_display_info import (
    MessagesApiMessageSenderDisplayInfo,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageContent(BaseModel):
    """
    Content of the message.
    """  # noqa: E501

    header: Optional[MessagesApiMessageHeader] = None
    body: MessagesApiMessageBody
    buttons: Optional[List[MessagesApiMessageButton]] = Field(
        default=None, description="List of buttons of the message."
    )
    confirmation_body: Optional[MessagesApiMessageConfirmationBody] = Field(
        default=None, alias="confirmationBody"
    )
    sender_display_info: Optional[MessagesApiMessageSenderDisplayInfo] = Field(
        default=None, alias="senderDisplayInfo"
    )
    footer: Optional[MessagesApiMessageFooter] = None
    __properties: ClassVar[List[str]] = [
        "header",
        "body",
        "buttons",
        "confirmationBody",
        "senderDisplayInfo",
        "footer",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of header
        if self.header:
            _dict["header"] = self.header.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict["body"] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in buttons (list)
        _items = []
        if self.buttons:
            for _item_buttons in self.buttons:
                if _item_buttons:
                    _items.append(_item_buttons.to_dict())
            _dict["buttons"] = _items
        # override the default output from pydantic by calling `to_dict()` of confirmation_body
        if self.confirmation_body:
            _dict["confirmationBody"] = self.confirmation_body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender_display_info
        if self.sender_display_info:
            _dict["senderDisplayInfo"] = self.sender_display_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of footer
        if self.footer:
            _dict["footer"] = self.footer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "header": (
                    MessagesApiMessageHeader.from_dict(obj["header"])
                    if obj.get("header") is not None
                    else None
                ),
                "body": (
                    MessagesApiMessageBody.from_dict(obj["body"])
                    if obj.get("body") is not None
                    else None
                ),
                "buttons": (
                    [
                        MessagesApiMessageButton.from_dict(_item)
                        for _item in obj["buttons"]
                    ]
                    if obj.get("buttons") is not None
                    else None
                ),
                "confirmationBody": (
                    MessagesApiMessageConfirmationBody.from_dict(
                        obj["confirmationBody"]
                    )
                    if obj.get("confirmationBody") is not None
                    else None
                ),
                "senderDisplayInfo": (
                    MessagesApiMessageSenderDisplayInfo.from_dict(
                        obj["senderDisplayInfo"]
                    )
                    if obj.get("senderDisplayInfo") is not None
                    else None
                ),
                "footer": (
                    MessagesApiMessageFooter.from_dict(obj["footer"])
                    if obj.get("footer") is not None
                    else None
                ),
            }
        )
        return _obj
