# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageDatePickerFormPageOptions(BaseModel):
    """
    Options of the page.
    """  # noqa: E501

    date_format: Optional[StrictStr] = Field(
        default=None,
        description="Date format used on the page e.g. `MM/dd/yyyy`.",
        alias="dateFormat",
    )
    start_date: Optional[datetime] = Field(
        default=None,
        description="Date displayed by the date picker. Has the following format: `YYYY-MM-DD`.",
        alias="startDate",
    )
    maximum_date: Optional[datetime] = Field(
        default=None,
        description="Maximum date that the date picker can show. Has the following format: `YYYY-MM-DD`.",
        alias="maximumDate",
    )
    minimum_date: Optional[datetime] = Field(
        default=None,
        description="Minimum date that the date picker can show. Has the following format: `YYYY-MM-DD`.",
        alias="minimumDate",
    )
    date_label: Optional[StrictStr] = Field(
        default=None,
        description="Text to be shown next to the date field.",
        alias="dateLabel",
    )
    __properties: ClassVar[List[str]] = [
        "dateFormat",
        "startDate",
        "maximumDate",
        "minimumDate",
        "dateLabel",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageDatePickerFormPageOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageDatePickerFormPageOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "dateFormat": obj.get("dateFormat"),
                "startDate": obj.get("startDate"),
                "maximumDate": obj.get("maximumDate"),
                "minimumDate": obj.get("minimumDate"),
                "dateLabel": obj.get("dateLabel"),
            }
        )
        return _obj
