# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
import pprint
from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing import Any, Optional
from infobip_api_client.models.messages_api_channels_destination import (
    MessagesApiChannelsDestination,
)
from infobip_api_client.models.messages_api_to_destination import (
    MessagesApiToDestination,
)
from typing import Union, Set, Optional, Dict
from typing_extensions import Self

MESSAGESAPIMESSAGEDESTINATION_ONE_OF_SCHEMAS = [
    "MessagesApiChannelsDestination",
    "MessagesApiToDestination",
]


class MessagesApiMessageDestination(BaseModel):
    """
    Array of destination objects for where messages are being sent. A valid destination is required. \"Channels Destination\" is required when sending messages with defined failover.
    """

    # data type: MessagesApiChannelsDestination
    oneof_schema_1_validator: Optional[MessagesApiChannelsDestination] = None
    # data type: MessagesApiToDestination
    oneof_schema_2_validator: Optional[MessagesApiToDestination] = None
    actual_instance: Optional[
        Union[MessagesApiChannelsDestination, MessagesApiToDestination]
    ] = None
    one_of_schemas: Set[str] = {
        "MessagesApiChannelsDestination",
        "MessagesApiToDestination",
    }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = MessagesApiMessageDestination.model_construct()
        error_messages = []
        match = 0
        # validate data type: MessagesApiChannelsDestination
        if not isinstance(v, MessagesApiChannelsDestination):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MessagesApiChannelsDestination`"
            )
        else:
            match += 1
        # validate data type: MessagesApiToDestination
        if not isinstance(v, MessagesApiToDestination):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MessagesApiToDestination`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in MessagesApiMessageDestination with oneOf schemas: MessagesApiChannelsDestination, MessagesApiToDestination. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in MessagesApiMessageDestination with oneOf schemas: MessagesApiChannelsDestination, MessagesApiToDestination. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into MessagesApiChannelsDestination
        try:
            instance.actual_instance = MessagesApiChannelsDestination.from_json(
                json_str
            )
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessagesApiToDestination
        try:
            instance.actual_instance = MessagesApiToDestination.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into MessagesApiMessageDestination with oneOf schemas: MessagesApiChannelsDestination, MessagesApiToDestination. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into MessagesApiMessageDestination with oneOf schemas: MessagesApiChannelsDestination, MessagesApiToDestination. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[Dict[str, Any], MessagesApiChannelsDestination, MessagesApiToDestination]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
