# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_message_body import MessagesApiMessageBody
from infobip_api_client.models.messages_api_message_body_type import (
    MessagesApiMessageBodyType,
)
from infobip_api_client.models.messages_api_message_form_page import (
    MessagesApiMessageFormPage,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageFormBody(MessagesApiMessageBody):
    """
    MessagesApiMessageFormBody
    """  # noqa: E501

    text: StrictStr = Field(description="Text of the received message.")
    image_url: Optional[StrictStr] = Field(
        default=None, description="Image of the received message.", alias="imageUrl"
    )
    pages: List[MessagesApiMessageFormPage] = Field(
        description="An array of different pages to be shown in the form. If INTRO page is included it will always appear first."
    )
    start_page_identifier: Annotated[
        str, Field(min_length=0, strict=True, max_length=20)
    ] = Field(
        description="Identifier for the starting page of the form. Must match one of the string identifiers for the configured pages.",
        alias="startPageIdentifier",
    )
    is_private: Optional[StrictBool] = Field(
        default=False,
        description="Indicates whether to mark the response as private.",
        alias="isPrivate",
    )
    show_summary: Optional[StrictBool] = Field(
        default=False,
        description="If set to true then it shows the summary of all the selections made within the form.",
        alias="showSummary",
    )
    type: MessagesApiMessageBodyType = "FORM"
    __properties: ClassVar[List[str]] = [
        "type",
        "text",
        "imageUrl",
        "pages",
        "startPageIdentifier",
        "isPrivate",
        "showSummary",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageFormBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in pages (list)
        _items = []
        if self.pages:
            for _item_pages in self.pages:
                if _item_pages:
                    _items.append(_item_pages.to_dict())
            _dict["pages"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageFormBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "text": obj.get("text"),
                "imageUrl": obj.get("imageUrl"),
                "pages": (
                    [
                        MessagesApiMessageFormPage.from_dict(_item)
                        for _item in obj["pages"]
                    ]
                    if obj.get("pages") is not None
                    else None
                ),
                "startPageIdentifier": obj.get("startPageIdentifier"),
                "isPrivate": (
                    obj.get("isPrivate") if obj.get("isPrivate") is not None else False
                ),
                "showSummary": (
                    obj.get("showSummary")
                    if obj.get("showSummary") is not None
                    else False
                ),
            }
        )
        return _obj
