# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_message_input_form_input_type import (
    MessagesApiMessageInputFormInputType,
)
from infobip_api_client.models.messages_api_message_input_form_page_keyboard import (
    MessagesApiMessageInputFormPageKeyboard,
)
from infobip_api_client.models.messages_api_message_input_form_page_text_content_type import (
    MessagesApiMessageInputFormPageTextContentType,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageInputFormPageOptions(BaseModel):
    """
    Options of the page.
    """  # noqa: E501

    hint_text: Optional[StrictStr] = Field(
        default=None,
        description="Text to give the user more input context that displays below the Input field.",
        alias="hintText",
    )
    regex: Optional[StrictStr] = Field(
        default=None,
        description="String representing a JSON encoded regular expression (regex) string to limit the type of input for input field to use.",
    )
    placeholder: Optional[StrictStr] = Field(
        default=None,
        description="Text string used when there is no other text in the input text field.",
    )
    is_required: Optional[StrictBool] = Field(
        default=None,
        description="When set to true, the next button on page is disabled until the user provides input.",
        alias="isRequired",
    )
    input_type: Optional[MessagesApiMessageInputFormInputType] = Field(
        default=MessagesApiMessageInputFormInputType.SINGLELINE, alias="inputType"
    )
    label_text: Optional[StrictStr] = Field(
        default=None,
        description="Text label shown to identify the input field. Applicable only for SINGLELINE input type.",
        alias="labelText",
    )
    prefix_text: Optional[StrictStr] = Field(
        default=None,
        description="String value representing optional text shown next to the text field. Applicable only for SINGLELINE input type.",
        alias="prefixText",
    )
    maximum_character_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(
        default=None,
        description="Maximum field size in characters.",
        alias="maximumCharacterCount",
    )
    keyboard_type: Optional[MessagesApiMessageInputFormPageKeyboard] = Field(
        default=MessagesApiMessageInputFormPageKeyboard.DEFAULT, alias="keyboardType"
    )
    text_content_type: Optional[MessagesApiMessageInputFormPageTextContentType] = Field(
        default=None, alias="textContentType"
    )
    __properties: ClassVar[List[str]] = [
        "hintText",
        "regex",
        "placeholder",
        "isRequired",
        "inputType",
        "labelText",
        "prefixText",
        "maximumCharacterCount",
        "keyboardType",
        "textContentType",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageInputFormPageOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageInputFormPageOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "hintText": obj.get("hintText"),
                "regex": obj.get("regex"),
                "placeholder": obj.get("placeholder"),
                "isRequired": obj.get("isRequired"),
                "inputType": obj.get("inputType"),
                "labelText": obj.get("labelText"),
                "prefixText": obj.get("prefixText"),
                "maximumCharacterCount": obj.get("maximumCharacterCount"),
                "keyboardType": obj.get("keyboardType"),
                "textContentType": obj.get("textContentType"),
            }
        )
        return _obj
