# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_regional_options import (
    MessagesApiRegionalOptions,
)
from infobip_api_client.models.messages_api_traffic_type import MessagesApiTrafficType
from infobip_api_client.models.messages_api_transliteration_code import (
    MessagesApiTransliterationCode,
)
from infobip_api_client.models.platform import Platform
from infobip_api_client.models.validity_period import ValidityPeriod
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageOptions(BaseModel):
    """
    Message options.
    """  # noqa: E501

    platform: Optional[Platform] = None
    validity_period: Optional[ValidityPeriod] = Field(
        default=None, alias="validityPeriod"
    )
    adaptation_mode: Optional[StrictBool] = Field(
        default=True,
        description="If channel does not fully support message to be sent, we will try to map it as best effort. This is default behavior, even if this option is not specified.",
        alias="adaptationMode",
    )
    regional: Optional[MessagesApiRegionalOptions] = None
    campaign_reference_id: Optional[StrictStr] = Field(
        default=None,
        description="ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns per sending channel.",
        alias="campaignReferenceId",
    )
    transliteration: Optional[MessagesApiTransliterationCode] = None
    correlation_data: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=100)]
    ] = Field(
        default=None,
        description="Correlation data included in the outbound message. If provided, it will be returned in the inbound message. Auto-generated if not set explicitly.",
        alias="correlationData",
    )
    traffic_type: Optional[MessagesApiTrafficType] = Field(
        default=None, alias="trafficType"
    )
    session_rate: Optional[StrictBool] = Field(
        default=None,
        description="Defines if the message should be charged using session rate. Supported by Viber for content with text/image/document only (without buttons, extra text etc.) body type. For text/image only body types `sessionRate` won't be applied if parameter `primaryDevice` is set to true.",
        alias="sessionRate",
    )
    primary_device: Optional[StrictBool] = Field(
        default=None,
        description="Defines if the message should be sent only to the end user's primary device (phone or tablet). Supported by Viber for message with content with text/image/document only (without buttons, extra text etc.) body type or template message.",
        alias="primaryDevice",
    )
    __properties: ClassVar[List[str]] = [
        "platform",
        "validityPeriod",
        "adaptationMode",
        "regional",
        "campaignReferenceId",
        "transliteration",
        "correlationData",
        "trafficType",
        "sessionRate",
        "primaryDevice",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validity_period
        if self.validity_period:
            _dict["validityPeriod"] = self.validity_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of regional
        if self.regional:
            _dict["regional"] = self.regional.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "validityPeriod": (
                    ValidityPeriod.from_dict(obj["validityPeriod"])
                    if obj.get("validityPeriod") is not None
                    else None
                ),
                "adaptationMode": (
                    obj.get("adaptationMode")
                    if obj.get("adaptationMode") is not None
                    else True
                ),
                "regional": (
                    MessagesApiRegionalOptions.from_dict(obj["regional"])
                    if obj.get("regional") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
                "transliteration": obj.get("transliteration"),
                "correlationData": obj.get("correlationData"),
                "trafficType": obj.get("trafficType"),
                "sessionRate": obj.get("sessionRate"),
                "primaryDevice": obj.get("primaryDevice"),
            }
        )
        return _obj
