# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from infobip_api_client.models.messages_api_message_order_importer import (
    MessagesApiMessageOrderImporter,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageOrderItem(BaseModel):
    """
    An array of items in the order.
    """  # noqa: E501

    name: StrictStr = Field(description="Name of the item.")
    retailer_id: Optional[StrictStr] = Field(
        default=None,
        description="(WhatsApp specific, and required) Product-unique identifier, as defined in catalog.",
        alias="retailerId",
    )
    quantity: Optional[StrictInt] = Field(
        default=None, description="(WhatsApp specific) Item quantity."
    )
    amount: Union[StrictFloat, StrictInt] = Field(
        description="Price of the item (up to 2 decimal places). For WhatsApp it has to be multiplied by offset (100 for `INR` and `BRL`)"
    )
    sale_amount: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="(WhatsApp specific) Item discount (up to 2 decimal places). For WhatsApp it has to be multiplied by offset (100 for `INR` and `BRL`)",
        alias="saleAmount",
    )
    importer: Optional[MessagesApiMessageOrderImporter] = None
    __properties: ClassVar[List[str]] = [
        "name",
        "retailerId",
        "quantity",
        "amount",
        "saleAmount",
        "importer",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOrderItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of importer
        if self.importer:
            _dict["importer"] = self.importer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOrderItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "retailerId": obj.get("retailerId"),
                "quantity": obj.get("quantity"),
                "amount": obj.get("amount"),
                "saleAmount": obj.get("saleAmount"),
                "importer": (
                    MessagesApiMessageOrderImporter.from_dict(obj["importer"])
                    if obj.get("importer") is not None
                    else None
                ),
            }
        )
        return _obj
