# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Union
from infobip_api_client.models.messages_api_message_payment_configuration_type import (
    MessagesApiMessagePaymentConfigurationType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.messages_api_message_apple_pay_payment_configuration import (
        MessagesApiMessageApplePayPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_brazil_payment_configuration import (
        MessagesApiMessageBrazilPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_brazil_boleto_payment_configuration import (
        MessagesApiMessageBrazilBoletoPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_brazil_link_payment_configuration import (
        MessagesApiMessageBrazilLinkPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_brazil_pix_dc_payment_configuration import (
        MessagesApiMessageBrazilPixDcPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_pg_payu_payment_configuration import (
        MessagesApiMessagePgPayuPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_upi_pg_razorpay_payment_configuration import (
        MessagesApiMessageUpiPgRazorpayPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_upi_intent_payment_configuration import (
        MessagesApiMessageUpiIntentPaymentConfiguration,
    )
    from infobip_api_client.models.messages_api_message_upi_payu_payment_configuration import (
        MessagesApiMessageUpiPayuPaymentConfiguration,
    )


class MessagesApiMessagePaymentConfiguration(BaseModel):
    """
    Required for WhatsApp, optional for Apple. Type of the payment.
    """  # noqa: E501

    type: MessagesApiMessagePaymentConfigurationType
    __properties: ClassVar[List[str]] = ["type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "APPLE_PAY": "MessagesApiMessageApplePayPaymentConfiguration",
        "BRAZIL": "MessagesApiMessageBrazilPaymentConfiguration",
        "BRAZIL_BOLETO": "MessagesApiMessageBrazilBoletoPaymentConfiguration",
        "BRAZIL_LINK": "MessagesApiMessageBrazilLinkPaymentConfiguration",
        "BRAZIL_PIX_DC": "MessagesApiMessageBrazilPixDcPaymentConfiguration",
        "PG_PAYU": "MessagesApiMessagePgPayuPaymentConfiguration",
        "PG_RAZORPAY": "MessagesApiMessageUpiPgRazorpayPaymentConfiguration",
        "UPI_INTENT": "MessagesApiMessageUpiIntentPaymentConfiguration",
        "UPI_PAYU": "MessagesApiMessageUpiPayuPaymentConfiguration",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            MessagesApiMessageApplePayPaymentConfiguration,
            MessagesApiMessageBrazilPaymentConfiguration,
            MessagesApiMessageBrazilBoletoPaymentConfiguration,
            MessagesApiMessageBrazilLinkPaymentConfiguration,
            MessagesApiMessageBrazilPixDcPaymentConfiguration,
            MessagesApiMessagePgPayuPaymentConfiguration,
            MessagesApiMessageUpiPgRazorpayPaymentConfiguration,
            MessagesApiMessageUpiIntentPaymentConfiguration,
            MessagesApiMessageUpiPayuPaymentConfiguration,
        ]
    ]:
        """Create an instance of MessagesApiMessagePaymentConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            MessagesApiMessageApplePayPaymentConfiguration,
            MessagesApiMessageBrazilPaymentConfiguration,
            MessagesApiMessageBrazilBoletoPaymentConfiguration,
            MessagesApiMessageBrazilLinkPaymentConfiguration,
            MessagesApiMessageBrazilPixDcPaymentConfiguration,
            MessagesApiMessagePgPayuPaymentConfiguration,
            MessagesApiMessageUpiPgRazorpayPaymentConfiguration,
            MessagesApiMessageUpiIntentPaymentConfiguration,
            MessagesApiMessageUpiPayuPaymentConfiguration,
        ]
    ]:
        """Create an instance of MessagesApiMessagePaymentConfiguration from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MessagesApiMessageApplePayPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_apple_pay_payment_configuration"
            ).MessagesApiMessageApplePayPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageBrazilPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_brazil_payment_configuration"
            ).MessagesApiMessageBrazilPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageBrazilBoletoPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_brazil_boleto_payment_configuration"
            ).MessagesApiMessageBrazilBoletoPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageBrazilLinkPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_brazil_link_payment_configuration"
            ).MessagesApiMessageBrazilLinkPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageBrazilPixDcPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_brazil_pix_dc_payment_configuration"
            ).MessagesApiMessageBrazilPixDcPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessagePgPayuPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_pg_payu_payment_configuration"
            ).MessagesApiMessagePgPayuPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageUpiPgRazorpayPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_upi_pg_razorpay_payment_configuration"
            ).MessagesApiMessageUpiPgRazorpayPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageUpiIntentPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_upi_intent_payment_configuration"
            ).MessagesApiMessageUpiIntentPaymentConfiguration.from_dict(obj)
        if object_type == "MessagesApiMessageUpiPayuPaymentConfiguration":
            return import_module(
                "infobip_api_client.models.messages_api_message_upi_payu_payment_configuration"
            ).MessagesApiMessageUpiPayuPaymentConfiguration.from_dict(obj)

        raise ValueError(
            "MessagesApiMessagePaymentConfiguration failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
