# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_message_time_picker_location import (
    MessagesApiMessageTimePickerLocation,
)
from infobip_api_client.models.messages_api_message_time_picker_timeslot import (
    MessagesApiMessageTimePickerTimeslot,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageTimePickerEvent(BaseModel):
    """
    Event with possible occurrences and location.
    """  # noqa: E501

    title: StrictStr = Field(description="Title of event.")
    timeslots: List[MessagesApiMessageTimePickerTimeslot] = Field(
        description="Possible timeslots for event."
    )
    location: Optional[MessagesApiMessageTimePickerLocation] = None
    image_url: Optional[StrictStr] = Field(
        default=None, description="URL of the event's image.", alias="imageUrl"
    )
    __properties: ClassVar[List[str]] = ["title", "timeslots", "location", "imageUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageTimePickerEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in timeslots (list)
        _items = []
        if self.timeslots:
            for _item_timeslots in self.timeslots:
                if _item_timeslots:
                    _items.append(_item_timeslots.to_dict())
            _dict["timeslots"] = _items
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict["location"] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageTimePickerEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "title": obj.get("title"),
                "timeslots": (
                    [
                        MessagesApiMessageTimePickerTimeslot.from_dict(_item)
                        for _item in obj["timeslots"]
                    ]
                    if obj.get("timeslots") is not None
                    else None
                ),
                "location": (
                    MessagesApiMessageTimePickerLocation.from_dict(obj["location"])
                    if obj.get("location") is not None
                    else None
                ),
                "imageUrl": obj.get("imageUrl"),
            }
        )
        return _obj
