# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.messages_api_message_payment_configuration import (
    MessagesApiMessagePaymentConfiguration,
)
from infobip_api_client.models.messages_api_message_payment_configuration_type import (
    MessagesApiMessagePaymentConfigurationType,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageUpiPayuPaymentConfiguration(
    MessagesApiMessagePaymentConfiguration
):
    """
    MessagesApiMessageUpiPayuPaymentConfiguration
    """  # noqa: E501

    id: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=25)]] = (
        Field(default=None, description="Unique identifier of the payment.")
    )
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=60)]] = (
        Field(
            default=None,
            description="Name of the WhatsApp payment configuration to be used for this order.",
        )
    )
    product_description: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=100)]
    ] = Field(
        default=None,
        description="Brief description of products in this order.",
        alias="productDescription",
    )
    customer_first_name: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=60)]
    ] = Field(
        default=None, description="Customer's first name.", alias="customerFirstName"
    )
    customer_last_name: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=20)]
    ] = Field(
        default=None, description="Customer's last name.", alias="customerLastName"
    )
    customer_email: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=50)]
    ] = Field(default=None, description="Customer's email.", alias="customerEmail")
    callback_data: Optional[
        Annotated[
            List[Annotated[str, Field(min_length=0, strict=True, max_length=255)]],
            Field(min_length=0, max_length=5),
        ]
    ] = Field(
        default=None,
        description="List of custom parameters corresponding to the transaction.",
        alias="callbackData",
    )
    type: MessagesApiMessagePaymentConfigurationType = "UPI_PAYU"
    __properties: ClassVar[List[str]] = [
        "type",
        "id",
        "name",
        "productDescription",
        "customerFirstName",
        "customerLastName",
        "customerEmail",
        "callbackData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageUpiPayuPaymentConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageUpiPayuPaymentConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "id": obj.get("id"),
                "name": obj.get("name"),
                "productDescription": obj.get("productDescription"),
                "customerFirstName": obj.get("customerFirstName"),
                "customerLastName": obj.get("customerLastName"),
                "customerEmail": obj.get("customerEmail"),
                "callbackData": obj.get("callbackData"),
            }
        )
        return _obj
