# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_inbound_seen_channel import (
    MessagesApiInboundSeenChannel,
)
from infobip_api_client.models.platform import Platform
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiSeenResult(BaseModel):
    """
    Collection of reports, one per every message.
    """  # noqa: E501

    event: StrictStr = Field(description="Event type (seen report in this case).")
    channel: MessagesApiInboundSeenChannel
    sender: StrictStr = Field(
        description="The sender ID which can be alphanumeric or numeric (e.g., `CompanyName`)."
    )
    destination: StrictStr = Field(description="Message destination address.")
    sent_at: StrictStr = Field(
        description="Tells when the message was sent. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.",
        alias="sentAt",
    )
    seen_at: StrictStr = Field(
        description="Tells when the message was seen. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.",
        alias="seenAt",
    )
    bulk_id: StrictStr = Field(
        description="The ID that uniquely identifies the request.", alias="bulkId"
    )
    message_id: StrictStr = Field(
        description="The ID that uniquely identifies the received message.",
        alias="messageId",
    )
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="Value of the `callbackData` field from the MT message (if exists) or from the MO Action setup (if exists).",
        alias="callbackData",
    )
    platform: Optional[Platform] = None
    campaign_reference_id: Optional[StrictStr] = Field(
        default=None,
        description="ID of a campaign that was sent in the message.",
        alias="campaignReferenceId",
    )
    __properties: ClassVar[List[str]] = [
        "event",
        "channel",
        "sender",
        "destination",
        "sentAt",
        "seenAt",
        "bulkId",
        "messageId",
        "callbackData",
        "platform",
        "campaignReferenceId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiSeenResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiSeenResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "event": obj.get("event") if obj.get("event") is not None else "SEEN",
                "channel": obj.get("channel"),
                "sender": obj.get("sender"),
                "destination": obj.get("destination"),
                "sentAt": obj.get("sentAt"),
                "seenAt": obj.get("seenAt"),
                "bulkId": obj.get("bulkId"),
                "messageId": obj.get("messageId"),
                "callbackData": obj.get("callbackData"),
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
            }
        )
        return _obj
