# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Union
from infobip_api_client.models.messages_api_template_button_type import (
    MessagesApiTemplateButtonType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.messages_api_template_catalog_button import (
        MessagesApiTemplateCatalogButton,
    )
    from infobip_api_client.models.messages_api_template_copy_code_button import (
        MessagesApiTemplateCopyCodeButton,
    )
    from infobip_api_client.models.messages_api_template_flow_button import (
        MessagesApiTemplateFlowButton,
    )
    from infobip_api_client.models.messages_api_template_multi_product_button import (
        MessagesApiTemplateMultiProductButton,
    )
    from infobip_api_client.models.messages_api_template_open_url_button import (
        MessagesApiTemplateOpenUrlButton,
    )
    from infobip_api_client.models.messages_api_template_phone_number_button import (
        MessagesApiTemplatePhoneNumberButton,
    )
    from infobip_api_client.models.messages_api_template_quick_reply_button import (
        MessagesApiTemplateQuickReplyButton,
    )


class MessagesApiTemplateButton(BaseModel):
    """
    List of buttons of a template message.
    """  # noqa: E501

    type: MessagesApiTemplateButtonType
    __properties: ClassVar[List[str]] = ["type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "CATALOG": "MessagesApiTemplateCatalogButton",
        "COPY_CODE": "MessagesApiTemplateCopyCodeButton",
        "FLOW": "MessagesApiTemplateFlowButton",
        "MULTI_PRODUCT": "MessagesApiTemplateMultiProductButton",
        "OPEN_URL": "MessagesApiTemplateOpenUrlButton",
        "PHONE_NUMBER": "MessagesApiTemplatePhoneNumberButton",
        "QUICK_REPLY": "MessagesApiTemplateQuickReplyButton",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            MessagesApiTemplateCatalogButton,
            MessagesApiTemplateCopyCodeButton,
            MessagesApiTemplateFlowButton,
            MessagesApiTemplateMultiProductButton,
            MessagesApiTemplateOpenUrlButton,
            MessagesApiTemplatePhoneNumberButton,
            MessagesApiTemplateQuickReplyButton,
        ]
    ]:
        """Create an instance of MessagesApiTemplateButton from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            MessagesApiTemplateCatalogButton,
            MessagesApiTemplateCopyCodeButton,
            MessagesApiTemplateFlowButton,
            MessagesApiTemplateMultiProductButton,
            MessagesApiTemplateOpenUrlButton,
            MessagesApiTemplatePhoneNumberButton,
            MessagesApiTemplateQuickReplyButton,
        ]
    ]:
        """Create an instance of MessagesApiTemplateButton from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MessagesApiTemplateCatalogButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_catalog_button"
            ).MessagesApiTemplateCatalogButton.from_dict(obj)
        if object_type == "MessagesApiTemplateCopyCodeButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_copy_code_button"
            ).MessagesApiTemplateCopyCodeButton.from_dict(obj)
        if object_type == "MessagesApiTemplateFlowButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_flow_button"
            ).MessagesApiTemplateFlowButton.from_dict(obj)
        if object_type == "MessagesApiTemplateMultiProductButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_multi_product_button"
            ).MessagesApiTemplateMultiProductButton.from_dict(obj)
        if object_type == "MessagesApiTemplateOpenUrlButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_open_url_button"
            ).MessagesApiTemplateOpenUrlButton.from_dict(obj)
        if object_type == "MessagesApiTemplatePhoneNumberButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_phone_number_button"
            ).MessagesApiTemplatePhoneNumberButton.from_dict(obj)
        if object_type == "MessagesApiTemplateQuickReplyButton":
            return import_module(
                "infobip_api_client.models.messages_api_template_quick_reply_button"
            ).MessagesApiTemplateQuickReplyButton.from_dict(obj)

        raise ValueError(
            "MessagesApiTemplateButton failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
