# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_inbound_event import MessagesApiInboundEvent
from infobip_api_client.models.messages_api_inbound_event_type import (
    MessagesApiInboundEventType,
)
from infobip_api_client.models.messages_api_inbound_mo_event_channel import (
    MessagesApiInboundMoEventChannel,
)
from infobip_api_client.models.messages_api_webhook_event_content import (
    MessagesApiWebhookEventContent,
)
from infobip_api_client.models.messages_api_webhook_event_metadata import (
    MessagesApiWebhookEventMetadata,
)
from infobip_api_client.models.platform import Platform
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiWebhookEvent(MessagesApiInboundEvent):
    """
    MessagesApiWebhookEvent
    """  # noqa: E501

    channel: MessagesApiInboundMoEventChannel
    sender: StrictStr = Field(
        description="Identifier (usually number) of the party which sent the message."
    )
    destination: StrictStr = Field(
        description="Sender provided during the activation process."
    )
    content: List[MessagesApiWebhookEventContent] = Field(
        description="Content of the message."
    )
    received_at: datetime = Field(
        description="Date and time when Infobip received the message.",
        alias="receivedAt",
    )
    message_id: StrictStr = Field(
        description="The ID that uniquely identifies the received message.",
        alias="messageId",
    )
    paired_message_id: Optional[StrictStr] = Field(
        default=None,
        description="Message ID of the MT message that this MO message is a response to.",
        alias="pairedMessageId",
    )
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="Value of the `callbackData` field from the MT message (if exists) or from the MO Action setup (if exists).",
        alias="callbackData",
    )
    message_count: StrictInt = Field(
        description="The number of parts the message content was split into.",
        alias="messageCount",
    )
    platform: Optional[Platform] = None
    campaign_reference_id: Optional[StrictStr] = Field(
        default=None,
        description="ID of a campaign that was sent in the MT message",
        alias="campaignReferenceId",
    )
    metadata: Optional[MessagesApiWebhookEventMetadata] = None
    event: MessagesApiInboundEventType = "MO"
    __properties: ClassVar[List[str]] = [
        "event",
        "channel",
        "sender",
        "destination",
        "content",
        "receivedAt",
        "messageId",
        "pairedMessageId",
        "callbackData",
        "messageCount",
        "platform",
        "campaignReferenceId",
        "metadata",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiWebhookEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item_content in self.content:
                if _item_content:
                    _items.append(_item_content.to_dict())
            _dict["content"] = _items
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict["metadata"] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiWebhookEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "event": obj.get("event"),
                "channel": obj.get("channel"),
                "sender": obj.get("sender"),
                "destination": obj.get("destination"),
                "content": (
                    [
                        MessagesApiWebhookEventContent.from_dict(_item)
                        for _item in obj["content"]
                    ]
                    if obj.get("content") is not None
                    else None
                ),
                "receivedAt": obj.get("receivedAt"),
                "messageId": obj.get("messageId"),
                "pairedMessageId": obj.get("pairedMessageId"),
                "callbackData": obj.get("callbackData"),
                "messageCount": obj.get("messageCount"),
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
                "metadata": (
                    MessagesApiWebhookEventMetadata.from_dict(obj["metadata"])
                    if obj.get("metadata") is not None
                    else None
                ),
            }
        )
        return _obj
