# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.message_price import MessagePrice
from infobip_api_client.models.platform import Platform
from infobip_api_client.models.sms_message_content import SmsMessageContent
from infobip_api_client.models.sms_message_error import SmsMessageError
from infobip_api_client.models.sms_message_status import SmsMessageStatus
from typing import Optional, Set
from typing_extensions import Self


class SmsLog(BaseModel):
    """
    An array of message log results, one object per each message log entry.
    """  # noqa: E501

    sender: Optional[StrictStr] = Field(
        default=None, description="The sender ID which can be alphanumeric or numeric."
    )
    destination: Optional[StrictStr] = Field(
        default=None, description="Message destination address."
    )
    bulk_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request.",
        alias="bulkId",
    )
    message_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique message ID for which a log is requested.",
        alias="messageId",
    )
    sent_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the message was sent. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.",
        alias="sentAt",
    )
    done_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the Infobip services finished processing the message (i.e., delivered to the destination, network, etc.). Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.",
        alias="doneAt",
    )
    message_count: Optional[StrictInt] = Field(
        default=None,
        description="The number of messages content was split to.",
        alias="messageCount",
    )
    price: Optional[MessagePrice] = None
    status: Optional[SmsMessageStatus] = None
    error: Optional[SmsMessageError] = None
    platform: Optional[Platform] = None
    content: Optional[SmsMessageContent] = None
    campaign_reference_id: Optional[StrictStr] = Field(
        default=None,
        description="ID of a campaign that was sent in the message.",
        alias="campaignReferenceId",
    )
    mcc_mnc: Optional[StrictStr] = Field(
        default=None, description="Mobile country and network codes.", alias="mccMnc"
    )
    __properties: ClassVar[List[str]] = [
        "sender",
        "destination",
        "bulkId",
        "messageId",
        "sentAt",
        "doneAt",
        "messageCount",
        "price",
        "status",
        "error",
        "platform",
        "content",
        "campaignReferenceId",
        "mccMnc",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict["price"] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict["error"] = self.error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict["content"] = self.content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "sender": obj.get("sender"),
                "destination": obj.get("destination"),
                "bulkId": obj.get("bulkId"),
                "messageId": obj.get("messageId"),
                "sentAt": obj.get("sentAt"),
                "doneAt": obj.get("doneAt"),
                "messageCount": obj.get("messageCount"),
                "price": (
                    MessagePrice.from_dict(obj["price"])
                    if obj.get("price") is not None
                    else None
                ),
                "status": (
                    SmsMessageStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
                "error": (
                    SmsMessageError.from_dict(obj["error"])
                    if obj.get("error") is not None
                    else None
                ),
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "content": (
                    SmsMessageContent.from_dict(obj["content"])
                    if obj.get("content") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
                "mccMnc": obj.get("mccMnc"),
            }
        )
        return _obj
