# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.sms_language_configuration import (
    SmsLanguageConfiguration,
)
from typing import Optional, Set
from typing_extensions import Self


class SmsPreview(BaseModel):
    """
    Allows for previewing the original message content once additional language configuration has been applied to it.
    """  # noqa: E501

    text_preview: Optional[StrictStr] = Field(
        default=None,
        description="Preview of the message content as it should appear on the recipient’s device.",
        alias="textPreview",
    )
    message_count: Optional[StrictInt] = Field(
        default=None,
        description="Number of SMS message parts required to deliver the message.",
        alias="messageCount",
    )
    characters_remaining: Optional[StrictInt] = Field(
        default=None,
        description="Number of remaining characters in the last part of the SMS.",
        alias="charactersRemaining",
    )
    configuration: Optional[SmsLanguageConfiguration] = None
    __properties: ClassVar[List[str]] = [
        "textPreview",
        "messageCount",
        "charactersRemaining",
        "configuration",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsPreview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict["configuration"] = self.configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsPreview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "textPreview": obj.get("textPreview"),
                "messageCount": obj.get("messageCount"),
                "charactersRemaining": obj.get("charactersRemaining"),
                "configuration": (
                    SmsLanguageConfiguration.from_dict(obj["configuration"])
                    if obj.get("configuration") is not None
                    else None
                ),
            }
        )
        return _obj
