# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.delivery_time_window import DeliveryTimeWindow
from infobip_api_client.models.platform import Platform
from infobip_api_client.models.validity_period import ValidityPeriod
from infobip_api_client.models.viber_default_sms_failover import ViberDefaultSmsFailover
from infobip_api_client.models.viber_label import ViberLabel
from typing import Optional, Set
from typing_extensions import Self


class ViberMessageOptions(BaseModel):
    """
    Message options.
    """  # noqa: E501

    platform: Optional[Platform] = None
    validity_period: Optional[ValidityPeriod] = Field(
        default=None, alias="validityPeriod"
    )
    delivery_time_window: Optional[DeliveryTimeWindow] = Field(
        default=None, alias="deliveryTimeWindow"
    )
    campaign_reference_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=255)]
    ] = Field(
        default=None,
        description="ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns per sending channel.",
        alias="campaignReferenceId",
    )
    sms_failover: Optional[ViberDefaultSmsFailover] = Field(
        default=None, alias="smsFailover"
    )
    tracking_data: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=100)]
    ] = Field(
        default=None,
        description="Custom client's data that will be passed back with user's reply. It is not supported for `OTP_TEMPLATE` or when `toPrimaryDeviceOnly` option is enabled for text only and image only content types.",
        alias="trackingData",
    )
    label: Optional[ViberLabel] = None
    apply_session_rate: Optional[StrictBool] = Field(
        default=None,
        description="Defines if the message should be charged using Viber's session rate if applicable. The session rate is supported for text only, image only and `FILE` content types. For text only and image only content types `sessionRate` won't be applied if parameter `toPrimaryDeviceOnly` is set to `true`.",
        alias="applySessionRate",
    )
    to_primary_device_only: Optional[StrictBool] = Field(
        default=None,
        description="Defines if the message should be sent only to the end user's [primary device](https://www.infobip.com/docs/viber/business-messages/api) (phone or tablet). Primary device concept is supported for text only, image only, `FILE` and `OTP_TEMPLATE` content type.",
        alias="toPrimaryDeviceOnly",
    )
    __properties: ClassVar[List[str]] = [
        "platform",
        "validityPeriod",
        "deliveryTimeWindow",
        "campaignReferenceId",
        "smsFailover",
        "trackingData",
        "label",
        "applySessionRate",
        "toPrimaryDeviceOnly",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ViberMessageOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validity_period
        if self.validity_period:
            _dict["validityPeriod"] = self.validity_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_time_window
        if self.delivery_time_window:
            _dict["deliveryTimeWindow"] = self.delivery_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sms_failover
        if self.sms_failover:
            _dict["smsFailover"] = self.sms_failover.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViberMessageOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "platform": (
                    Platform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "validityPeriod": (
                    ValidityPeriod.from_dict(obj["validityPeriod"])
                    if obj.get("validityPeriod") is not None
                    else None
                ),
                "deliveryTimeWindow": (
                    DeliveryTimeWindow.from_dict(obj["deliveryTimeWindow"])
                    if obj.get("deliveryTimeWindow") is not None
                    else None
                ),
                "campaignReferenceId": obj.get("campaignReferenceId"),
                "smsFailover": (
                    ViberDefaultSmsFailover.from_dict(obj["smsFailover"])
                    if obj.get("smsFailover") is not None
                    else None
                ),
                "trackingData": obj.get("trackingData"),
                "label": obj.get("label"),
                "applySessionRate": obj.get("applySessionRate"),
                "toPrimaryDeviceOnly": obj.get("toPrimaryDeviceOnly"),
            }
        )
        return _obj
