# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from infobip_api_client.models.forms_response import FormsResponse
from infobip_api_client.models.forms_response_content import FormsResponseContent
from infobip_api_client.models.forms_status import FormsStatus
from infobip_api_client.models.forms_status_response import FormsStatusResponse

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.models.file_parameter import FileParameter
from infobip_api_client.rest import RESTResponseType


class FormsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_form(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FormsResponseContent:
        """Get form

        Use this method to get a form by its ID.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_form_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponseContent",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_form_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FormsResponseContent]:
        """Get form

        Use this method to get a form by its ID.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_form_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponseContent",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_form_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get form

        Use this method to get a form by its ID.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_form_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponseContent",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_form_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/forms/1/forms/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_forms(
        self,
        offset: Annotated[
            Optional[StrictInt],
            Field(description="Skip first {offset} forms of the list."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned forms. Maximum value is `100`."
            ),
        ] = None,
        form_type: Annotated[
            Optional[StrictStr], Field(description="The type of returned forms.")
        ] = None,
        form_status: Annotated[
            Optional[FormsStatus], Field(description="The status of returned forms.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FormsResponse:
        """Get forms

        Use this method to get a list of forms.

        :param offset: Skip first {offset} forms of the list.
        :type offset: int
        :param limit: The maximum number of returned forms. Maximum value is `100`.
        :type limit: int
        :param form_type: The type of returned forms.
        :type form_type: str
        :param form_status: The status of returned forms.
        :type form_status: FormsStatus
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_forms_serialize(
            offset=offset,
            limit=limit,
            form_type=form_type,
            form_status=form_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_forms_with_http_info(
        self,
        offset: Annotated[
            Optional[StrictInt],
            Field(description="Skip first {offset} forms of the list."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned forms. Maximum value is `100`."
            ),
        ] = None,
        form_type: Annotated[
            Optional[StrictStr], Field(description="The type of returned forms.")
        ] = None,
        form_status: Annotated[
            Optional[FormsStatus], Field(description="The status of returned forms.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FormsResponse]:
        """Get forms

        Use this method to get a list of forms.

        :param offset: Skip first {offset} forms of the list.
        :type offset: int
        :param limit: The maximum number of returned forms. Maximum value is `100`.
        :type limit: int
        :param form_type: The type of returned forms.
        :type form_type: str
        :param form_status: The status of returned forms.
        :type form_status: FormsStatus
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_forms_serialize(
            offset=offset,
            limit=limit,
            form_type=form_type,
            form_status=form_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_forms_without_preload_content(
        self,
        offset: Annotated[
            Optional[StrictInt],
            Field(description="Skip first {offset} forms of the list."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned forms. Maximum value is `100`."
            ),
        ] = None,
        form_type: Annotated[
            Optional[StrictStr], Field(description="The type of returned forms.")
        ] = None,
        form_status: Annotated[
            Optional[FormsStatus], Field(description="The status of returned forms.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get forms

        Use this method to get a list of forms.

        :param offset: Skip first {offset} forms of the list.
        :type offset: int
        :param limit: The maximum number of returned forms. Maximum value is `100`.
        :type limit: int
        :param form_type: The type of returned forms.
        :type form_type: str
        :param form_status: The status of returned forms.
        :type form_status: FormsStatus
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_forms_serialize(
            offset=offset,
            limit=limit,
            form_type=form_type,
            form_status=form_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_forms_serialize(
        self,
        offset,
        limit,
        form_type,
        form_status,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if offset is not None:

            _query_params.append(("offset", offset))

        if limit is not None:

            _query_params.append(("limit", limit))

        if form_type is not None:

            _query_params.append(("formType", form_type))

        if form_status is not None:

            _query_params.append(("formStatus", form_status.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/forms/1/forms",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def increment_view_count(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FormsStatusResponse:
        """Increment form view count

        Use this method to increase the view counter of a specific form. It's used for proper statistics calculation. Statistics are available on the form performance page on the Portal.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._increment_view_count_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def increment_view_count_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FormsStatusResponse]:
        """Increment form view count

        Use this method to increase the view counter of a specific form. It's used for proper statistics calculation. Statistics are available on the form performance page on the Portal.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._increment_view_count_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def increment_view_count_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Increment form view count

        Use this method to increase the view counter of a specific form. It's used for proper statistics calculation. Statistics are available on the form performance page on the Portal.

        :param id: ID of a form (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._increment_view_count_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _increment_view_count_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/forms/1/forms/{id}/views",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def submit_form_data(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        request_body: Annotated[
            Dict[str, Dict[str, Any]], Field(description="Form Data")
        ],
        ib_submission_source: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places."
            ),
        ] = None,
        ib_submission_form_campaign: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FormsStatusResponse:
        """Submit form data

        Use this method to submit form data.

        :param id: ID of a form (required)
        :type id: str
        :param request_body: Form Data (required)
        :type request_body: Dict[str, object]
        :param ib_submission_source: By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places.
        :type ib_submission_source: str
        :param ib_submission_form_campaign: By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns.
        :type ib_submission_form_campaign: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._submit_form_data_serialize(
            id=id,
            request_body=request_body,
            ib_submission_source=ib_submission_source,
            ib_submission_form_campaign=ib_submission_form_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def submit_form_data_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        request_body: Annotated[
            Dict[str, Dict[str, Any]], Field(description="Form Data")
        ],
        ib_submission_source: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places."
            ),
        ] = None,
        ib_submission_form_campaign: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FormsStatusResponse]:
        """Submit form data

        Use this method to submit form data.

        :param id: ID of a form (required)
        :type id: str
        :param request_body: Form Data (required)
        :type request_body: Dict[str, object]
        :param ib_submission_source: By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places.
        :type ib_submission_source: str
        :param ib_submission_form_campaign: By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns.
        :type ib_submission_form_campaign: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._submit_form_data_serialize(
            id=id,
            request_body=request_body,
            ib_submission_source=ib_submission_source,
            ib_submission_form_campaign=ib_submission_form_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def submit_form_data_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="ID of a form")],
        request_body: Annotated[
            Dict[str, Dict[str, Any]], Field(description="Form Data")
        ],
        ib_submission_source: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places."
            ),
        ] = None,
        ib_submission_form_campaign: Annotated[
            Optional[StrictStr],
            Field(
                description="By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Submit form data

        Use this method to submit form data.

        :param id: ID of a form (required)
        :type id: str
        :param request_body: Form Data (required)
        :type request_body: Dict[str, object]
        :param ib_submission_source: By sending source information you will be able to see Analytics by Source – It reflects the submission rates by source if your form is present in numerous places.
        :type ib_submission_source: str
        :param ib_submission_form_campaign: By sending campaign information you will be able to see Analytics by Campaign – It reflects the submission rates by campaign if your form is included in multiple campaigns.
        :type ib_submission_form_campaign: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._submit_form_data_serialize(
            id=id,
            request_body=request_body,
            ib_submission_source=ib_submission_source,
            ib_submission_form_campaign=ib_submission_form_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FormsStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _submit_form_data_serialize(
        self,
        id,
        request_body,
        ib_submission_source,
        ib_submission_form_campaign,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        if ib_submission_source is not None:
            _header_params["ib-submission-source"] = ib_submission_source
        if ib_submission_form_campaign is not None:
            _header_params["ib-submission-form-campaign"] = ib_submission_form_campaign
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/forms/1/forms/{id}/data",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
