# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from infobip_api_client.models.message_response import MessageResponse
from infobip_api_client.models.messages_api_channel import MessagesApiChannel
from infobip_api_client.models.messages_api_delivery_report import (
    MessagesApiDeliveryReport,
)
from infobip_api_client.models.messages_api_event_request import MessagesApiEventRequest
from infobip_api_client.models.messages_api_inbound_mo_get_endpoint_channel import (
    MessagesApiInboundMoGetEndpointChannel,
)
from infobip_api_client.models.messages_api_incoming_message_response import (
    MessagesApiIncomingMessageResponse,
)
from infobip_api_client.models.messages_api_request import MessagesApiRequest
from infobip_api_client.models.messages_api_validation_ok_response import (
    MessagesApiValidationOkResponse,
)

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.models.file_parameter import FileParameter
from infobip_api_client.rest import RESTResponseType


class MessagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_messages_api_delivery_reports(
        self,
        channel: Annotated[
            Optional[MessagesApiChannel],
            Field(
                description="Messaging channel for which the report will be fetched."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessagesApiDeliveryReport:
        """Get delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. This endpoint retrieves delivery reports for messages sent through Messages API as well as messages sent using channel-specific standalone APIs (for example, Viber, API, WhatsApp API, or SMS API). Please note they will be returned only once.

        :param channel: Messaging channel for which the report will be fetched.
        :type channel: MessagesApiChannel
        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_delivery_reports_serialize(
            channel=channel,
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiDeliveryReport",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_messages_api_delivery_reports_with_http_info(
        self,
        channel: Annotated[
            Optional[MessagesApiChannel],
            Field(
                description="Messaging channel for which the report will be fetched."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessagesApiDeliveryReport]:
        """Get delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. This endpoint retrieves delivery reports for messages sent through Messages API as well as messages sent using channel-specific standalone APIs (for example, Viber, API, WhatsApp API, or SMS API). Please note they will be returned only once.

        :param channel: Messaging channel for which the report will be fetched.
        :type channel: MessagesApiChannel
        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_delivery_reports_serialize(
            channel=channel,
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiDeliveryReport",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_messages_api_delivery_reports_without_preload_content(
        self,
        channel: Annotated[
            Optional[MessagesApiChannel],
            Field(
                description="Messaging channel for which the report will be fetched."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. This endpoint retrieves delivery reports for messages sent through Messages API as well as messages sent using channel-specific standalone APIs (for example, Viber, API, WhatsApp API, or SMS API). Please note they will be returned only once.

        :param channel: Messaging channel for which the report will be fetched.
        :type channel: MessagesApiChannel
        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_delivery_reports_serialize(
            channel=channel,
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiDeliveryReport",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_messages_api_delivery_reports_serialize(
        self,
        channel,
        bulk_id,
        message_id,
        limit,
        entity_id,
        application_id,
        campaign_reference_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if channel is not None:

            _query_params.append(("channel", channel.value))

        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if limit is not None:

            _query_params.append(("limit", limit))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/messages-api/1/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_messages_api_inbound_messages(
        self,
        channel: Annotated[
            MessagesApiInboundMoGetEndpointChannel,
            Field(
                description="Messaging channel for which inbound messages will be fetched."
            ),
        ],
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that message belongs to."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessagesApiIncomingMessageResponse:
        """Get inbound messages

        If you are unable to receive incoming messages to the endpoint of your choice in real-time, you can use this API call to fetch messages. Each request will return a batch of received messages, only once. The API request will only return new messages that arrived since the last API request.

        :param channel: Messaging channel for which inbound messages will be fetched. (required)
        :type channel: MessagesApiInboundMoGetEndpointChannel
        :param limit: Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param campaign_reference_id: ID of a campaign that message belongs to.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_inbound_messages_serialize(
            channel=channel,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiIncomingMessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_messages_api_inbound_messages_with_http_info(
        self,
        channel: Annotated[
            MessagesApiInboundMoGetEndpointChannel,
            Field(
                description="Messaging channel for which inbound messages will be fetched."
            ),
        ],
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that message belongs to."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessagesApiIncomingMessageResponse]:
        """Get inbound messages

        If you are unable to receive incoming messages to the endpoint of your choice in real-time, you can use this API call to fetch messages. Each request will return a batch of received messages, only once. The API request will only return new messages that arrived since the last API request.

        :param channel: Messaging channel for which inbound messages will be fetched. (required)
        :type channel: MessagesApiInboundMoGetEndpointChannel
        :param limit: Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param campaign_reference_id: ID of a campaign that message belongs to.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_inbound_messages_serialize(
            channel=channel,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiIncomingMessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_messages_api_inbound_messages_without_preload_content(
        self,
        channel: Annotated[
            MessagesApiInboundMoGetEndpointChannel,
            Field(
                description="Messaging channel for which inbound messages will be fetched."
            ),
        ],
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that message belongs to."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get inbound messages

        If you are unable to receive incoming messages to the endpoint of your choice in real-time, you can use this API call to fetch messages. Each request will return a batch of received messages, only once. The API request will only return new messages that arrived since the last API request.

        :param channel: Messaging channel for which inbound messages will be fetched. (required)
        :type channel: MessagesApiInboundMoGetEndpointChannel
        :param limit: Maximum number of messages to be returned in a response. If not set, last 50 records are returned. Maximum limit is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity ID that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param campaign_reference_id: ID of a campaign that message belongs to.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_messages_api_inbound_messages_serialize(
            channel=channel,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiIncomingMessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_messages_api_inbound_messages_serialize(
        self,
        channel,
        limit,
        application_id,
        entity_id,
        campaign_reference_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if channel is not None:

            _query_params.append(("channel", channel.value))

        if limit is not None:

            _query_params.append(("limit", limit))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/messages-api/1/inbound",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_messages_api_events(
        self,
        messages_api_event_request: MessagesApiEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessageResponse:
        """Send a Messages API event

        Send one or more events to multiple recipients.  An event is an interaction with end-user's device which does not impact messaging content of conversation.  Examples of events are: TYPING_STARTED, TYPING_STOPPED.

        :param messages_api_event_request: (required)
        :type messages_api_event_request: MessagesApiEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_events_serialize(
            messages_api_event_request=messages_api_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_messages_api_events_with_http_info(
        self,
        messages_api_event_request: MessagesApiEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessageResponse]:
        """Send a Messages API event

        Send one or more events to multiple recipients.  An event is an interaction with end-user's device which does not impact messaging content of conversation.  Examples of events are: TYPING_STARTED, TYPING_STOPPED.

        :param messages_api_event_request: (required)
        :type messages_api_event_request: MessagesApiEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_events_serialize(
            messages_api_event_request=messages_api_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_messages_api_events_without_preload_content(
        self,
        messages_api_event_request: MessagesApiEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send a Messages API event

        Send one or more events to multiple recipients.  An event is an interaction with end-user's device which does not impact messaging content of conversation.  Examples of events are: TYPING_STARTED, TYPING_STOPPED.

        :param messages_api_event_request: (required)
        :type messages_api_event_request: MessagesApiEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_events_serialize(
            messages_api_event_request=messages_api_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_messages_api_events_serialize(
        self,
        messages_api_event_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if messages_api_event_request is not None:
            _body_params = messages_api_event_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/messages-api/1/events",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_messages_api_message(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessageResponse:
        """Send a Messages API message

        Send messages at scale through multiple channels, utilizing various message types.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_messages_api_message_with_http_info(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessageResponse]:
        """Send a Messages API message

        Send messages at scale through multiple channels, utilizing various message types.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_messages_api_message_without_preload_content(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send a Messages API message

        Send messages at scale through multiple channels, utilizing various message types.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_messages_api_message_serialize(
        self,
        messages_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if messages_api_request is not None:
            _body_params = messages_api_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/messages-api/1/messages",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def validate_messages_api_message(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessagesApiValidationOkResponse:
        """Validate a Messages API message

        Perform a detailed validation of Messages API messages. This endpoint executes more specific checks than the `/messages` endpoint such as: possible channel-specific validations, verification of each failover step and unknown fields. Returns `200 OK` when the request would be accepted by the platform or `400 BAD_REQUEST` when it may fail at any point. Use this endpoint to validate messages before sending them to catch potential issues early.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiValidationOkResponse",
            "400": "MessagesApiValidationBadResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def validate_messages_api_message_with_http_info(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessagesApiValidationOkResponse]:
        """Validate a Messages API message

        Perform a detailed validation of Messages API messages. This endpoint executes more specific checks than the `/messages` endpoint such as: possible channel-specific validations, verification of each failover step and unknown fields. Returns `200 OK` when the request would be accepted by the platform or `400 BAD_REQUEST` when it may fail at any point. Use this endpoint to validate messages before sending them to catch potential issues early.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiValidationOkResponse",
            "400": "MessagesApiValidationBadResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def validate_messages_api_message_without_preload_content(
        self,
        messages_api_request: MessagesApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate a Messages API message

        Perform a detailed validation of Messages API messages. This endpoint executes more specific checks than the `/messages` endpoint such as: possible channel-specific validations, verification of each failover step and unknown fields. Returns `200 OK` when the request would be accepted by the platform or `400 BAD_REQUEST` when it may fail at any point. Use this endpoint to validate messages before sending them to catch potential issues early.

        :param messages_api_request: (required)
        :type messages_api_request: MessagesApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_messages_api_message_serialize(
            messages_api_request=messages_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessagesApiValidationOkResponse",
            "400": "MessagesApiValidationBadResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _validate_messages_api_message_serialize(
        self,
        messages_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if messages_api_request is not None:
            _body_params = messages_api_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/messages-api/1/messages/validate",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
