# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.message_general_status import MessageGeneralStatus
from infobip_api_client.models.message_response import MessageResponse
from infobip_api_client.models.viber_logs_response import ViberLogsResponse
from infobip_api_client.models.viber_request import ViberRequest
from infobip_api_client.models.viber_webhook_reports_response import (
    ViberWebhookReportsResponse,
)

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.models.file_parameter import FileParameter
from infobip_api_client.rest import RESTResponseType


class ViberApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_outbound_viber_message_delivery_reports(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ViberWebhookReportsResponse:
        """Get Viber delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. Please note they will be returned only once.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberWebhookReportsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_outbound_viber_message_delivery_reports_with_http_info(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ViberWebhookReportsResponse]:
        """Get Viber delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. Please note they will be returned only once.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberWebhookReportsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_outbound_viber_message_delivery_reports_without_preload_content(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h"
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(description="ID of a campaign that was sent in the message."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Viber delivery reports

        If you are unable to receive real-time delivery reports towards your endpoint for various reasons, we offer you an API method to fetch batches of delivery reports to confirm whether specific messages have been delivered. Each request towards this endpoint will return batches of the latest delivery reports. Please note they will be returned only once.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination address.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access reports for the last 48h
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message.
        :type campaign_reference_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberWebhookReportsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_outbound_viber_message_delivery_reports_serialize(
        self,
        bulk_id,
        message_id,
        limit,
        entity_id,
        application_id,
        campaign_reference_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if limit is not None:

            _query_params.append(("limit", limit))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/viber/2/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_outbound_viber_message_logs(
        self,
        sender: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        destination: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Optional[MessageGeneralStatus] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="ID of a campaign that was sent in the message. May contain multiple comma-separated values."
            ),
        ] = None,
        use_cursor: Annotated[
            Optional[StrictBool],
            Field(
                description="Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ViberLogsResponse:
        """Get Viber message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours.

        :param sender: The sender ID which can be alphanumeric or numeric.
        :type sender: str
        :param destination: Message destination address.
        :type destination: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status:
        :type general_status: MessageGeneralStatus
        :param sent_since: The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h.
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message. May contain multiple comma-separated values.
        :type campaign_reference_id: List[str]
        :param use_cursor: Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs.
        :type use_cursor: bool
        :param cursor: Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_logs_serialize(
            sender=sender,
            destination=destination,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            use_cursor=use_cursor,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberLogsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_outbound_viber_message_logs_with_http_info(
        self,
        sender: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        destination: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Optional[MessageGeneralStatus] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="ID of a campaign that was sent in the message. May contain multiple comma-separated values."
            ),
        ] = None,
        use_cursor: Annotated[
            Optional[StrictBool],
            Field(
                description="Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ViberLogsResponse]:
        """Get Viber message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours.

        :param sender: The sender ID which can be alphanumeric or numeric.
        :type sender: str
        :param destination: Message destination address.
        :type destination: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status:
        :type general_status: MessageGeneralStatus
        :param sent_since: The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h.
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message. May contain multiple comma-separated values.
        :type campaign_reference_id: List[str]
        :param use_cursor: Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs.
        :type use_cursor: bool
        :param cursor: Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_logs_serialize(
            sender=sender,
            destination=destination,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            use_cursor=use_cursor,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberLogsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_outbound_viber_message_logs_without_preload_content(
        self,
        sender: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        destination: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Optional[MessageGeneralStatus] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="ID of a campaign that was sent in the message. May contain multiple comma-separated values."
            ),
        ] = None,
        use_cursor: Annotated[
            Optional[StrictBool],
            Field(
                description="Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs."
            ),
        ] = None,
        cursor: Annotated[
            Optional[StrictStr],
            Field(
                description="Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Viber message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours.

        :param sender: The sender ID which can be alphanumeric or numeric.
        :type sender: str
        :param destination: Message destination address.
        :type destination: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status:
        :type general_status: MessageGeneralStatus
        :param sent_since: The logs will only include messages sent after this date. Use it alongside sentUntil to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it alongside sentSince to specify a time range for the logs, but only up to the maximum limit of 1000 logs per call. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is 1000 and you can only access logs for the last 48h.
        :type limit: int
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param campaign_reference_id: ID of a campaign that was sent in the message. May contain multiple comma-separated values.
        :type campaign_reference_id: List[str]
        :param use_cursor: Flag used to enable cursor-based pagination. When set to true, the system will use the cursor to fetch the next set of logs.
        :type use_cursor: bool
        :param cursor: Value which represents the current position in the data set. For the first request, this field shouldn't be defined. In subsequent requests, use the `nextCursor` value returned from the previous response to continue fetching data.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_viber_message_logs_serialize(
            sender=sender,
            destination=destination,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            entity_id=entity_id,
            application_id=application_id,
            campaign_reference_id=campaign_reference_id,
            use_cursor=use_cursor,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ViberLogsResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_outbound_viber_message_logs_serialize(
        self,
        sender,
        destination,
        bulk_id,
        message_id,
        general_status,
        sent_since,
        sent_until,
        limit,
        entity_id,
        application_id,
        campaign_reference_id,
        use_cursor,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "bulkId": "multi",
            "messageId": "multi",
            "campaignReferenceId": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sender is not None:

            _query_params.append(("sender", sender))

        if destination is not None:

            _query_params.append(("destination", destination))

        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if general_status is not None:

            _query_params.append(("generalStatus", general_status.value))

        if sent_since is not None:
            if isinstance(sent_since, datetime):
                _query_params.append(
                    (
                        "sentSince",
                        sent_since.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentSince", sent_since))

        if sent_until is not None:
            if isinstance(sent_until, datetime):
                _query_params.append(
                    (
                        "sentUntil",
                        sent_until.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentUntil", sent_until))

        if limit is not None:

            _query_params.append(("limit", limit))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        if use_cursor is not None:

            _query_params.append(("useCursor", use_cursor))

        if cursor is not None:

            _query_params.append(("cursor", cursor))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/viber/2/logs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_viber_messages(
        self,
        viber_request: ViberRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MessageResponse:
        """Send Viber messages

        Send text, image, video or file messages to a multiple recipients.

        :param viber_request: (required)
        :type viber_request: ViberRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_viber_messages_serialize(
            viber_request=viber_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_viber_messages_with_http_info(
        self,
        viber_request: ViberRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MessageResponse]:
        """Send Viber messages

        Send text, image, video or file messages to a multiple recipients.

        :param viber_request: (required)
        :type viber_request: ViberRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_viber_messages_serialize(
            viber_request=viber_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_viber_messages_without_preload_content(
        self,
        viber_request: ViberRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send Viber messages

        Send text, image, video or file messages to a multiple recipients.

        :param viber_request: (required)
        :type viber_request: ViberRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_viber_messages_serialize(
            viber_request=viber_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "MessageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_viber_messages_serialize(
        self,
        viber_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if viber_request is not None:
            _body_params = viber_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/viber/2/messages",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
