# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from infobip_api_client.models.call_routing_destination_type import (
    CallRoutingDestinationType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.call_routing_application_destination import (
        CallRoutingApplicationDestination,
    )
    from infobip_api_client.models.call_routing_endpoint_destination import (
        CallRoutingEndpointDestination,
    )
    from infobip_api_client.models.call_routing_url_destination import (
        CallRoutingUrlDestination,
    )


class CallRoutingDestination(BaseModel):
    """
    List of destinations. First destination in the list is the first one to be executed. Subsequent destinations are executed only if the previous one fails.
    """  # noqa: E501

    priority: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(
        default=None,
        description="Priority of the destination within a route. Destinations with lower value have higher priority. Either all or no destination need to have this value defined.",
    )
    type: CallRoutingDestinationType
    weight: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(
        default=None,
        description="Weight of the destination within a route. It specifies how much traffic is handled by destination relative to other destinations within the same priority level. Values are evaluated relative to each other and they don't need to add up to 100. Either all or no destination need to have this value defined.",
    )
    __properties: ClassVar[List[str]] = ["priority", "type", "weight"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "APPLICATION": "CallRoutingApplicationDestination",
        "ENDPOINT": "CallRoutingEndpointDestination",
        "URL": "CallRoutingUrlDestination",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            CallRoutingApplicationDestination,
            CallRoutingEndpointDestination,
            CallRoutingUrlDestination,
        ]
    ]:
        """Create an instance of CallRoutingDestination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            CallRoutingApplicationDestination,
            CallRoutingEndpointDestination,
            CallRoutingUrlDestination,
        ]
    ]:
        """Create an instance of CallRoutingDestination from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "CallRoutingApplicationDestination":
            return import_module(
                "infobip_api_client.models.call_routing_application_destination"
            ).CallRoutingApplicationDestination.from_dict(obj)
        if object_type == "CallRoutingEndpointDestination":
            return import_module(
                "infobip_api_client.models.call_routing_endpoint_destination"
            ).CallRoutingEndpointDestination.from_dict(obj)
        if object_type == "CallRoutingUrlDestination":
            return import_module(
                "infobip_api_client.models.call_routing_url_destination"
            ).CallRoutingUrlDestination.from_dict(obj)

        raise ValueError(
            "CallRoutingDestination failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
