# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from infobip_api_client.models.call_transfer import CallTransfer
from infobip_api_client.models.calls_destination import CallsDestination
from infobip_api_client.models.calls_retry import CallsRetry
from infobip_api_client.models.calls_sending_speed import CallsSendingSpeed
from infobip_api_client.models.calls_voice import CallsVoice
from infobip_api_client.models.delivery_time_window import DeliveryTimeWindow
from typing import Optional, Set
from typing_extensions import Self


class CallsAdvancedMessage(BaseModel):
    """
    Array of messages to be sent, one object per every message
    """  # noqa: E501

    audio_file_url: Optional[StrictStr] = Field(
        default=None,
        description="An audio file can be delivered as a voice message to the recipients. An audio file must be uploaded online, so that the existing URL can be available for file download. Size of the audio file must be below 4 MB. Supported formats of the provided file are aac, aiff, m4a, mp2, mp3, mp4 (audio only), ogg, wav and wma. Our platform needs to have permission to make GET and HEAD HTTP requests on the provided URL. Standard http ports (like 80, 8080, etc.) are advised.",
        alias="audioFileUrl",
    )
    call_timeout: Optional[StrictInt] = Field(
        default=None,
        description="Maximum possible duration of the call to be set, shown in seconds.",
        alias="callTimeout",
    )
    call_transfers: Optional[List[CallTransfer]] = Field(
        default=None,
        description="Call transfers object enables transferring the ongoing call to another recipient(s) and establish a communication between your original recipient and additional one.",
        alias="callTransfers",
    )
    callback_data: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=700)]
    ] = Field(
        default=None,
        description="Additional client's data that will be sent on the notifyUrl. The maximum value is 700 characters. Example:  `Text containing some additional data needed in Delivery Report`.",
        alias="callbackData",
    )
    delivery_time_window: Optional[DeliveryTimeWindow] = Field(
        default=None, alias="deliveryTimeWindow"
    )
    destinations: List[CallsDestination] = Field(
        description="Message destination addresses. Destination address must be in the E.164 standard format (Example: 41793026727). Maximum number of destination addresses is 20k."
    )
    dtmf_timeout: Optional[StrictInt] = Field(
        default=None,
        description="The waiting period for end user to enter DTMF digits. Default value is `10` seconds.",
        alias="dtmfTimeout",
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="Numeric sender ID in E.164 standard format (Example: 41793026727). This is caller ID that will be presented to the end user where applicable.",
        alias="from",
    )
    language: Optional[StrictStr] = Field(
        default=None,
        description="If the message is in text format, the language in which the message is written must be defined for correct pronunciation. More about Text-to-speech functionality and supported TTS languages can be found [here](https://www.infobip.com/docs/voice-and-video/outbound-calls#text-to-speech-voice-over-broadcast). If not set, default language is `English [en]`. If voice is not set, then default voice for that specific language is used. In the case of English language, the voice is `[Joanna]`.",
    )
    machine_detection: Optional[StrictStr] = Field(
        default=None,
        description="Used for enabling detection of answering machine after the call has been answered. It can be set to `hangup` or `continue`. When set to `hangup`, if a machine is detected call will hang up. When set to `continue`, if a machine is detected, then voice message starts playing into voice mail after the answering message is finished with its greeting. If machineDetection is used, there is a minimum of 4 seconds detection time, which can result in delay of playing the message. Answering machine detection is additionally charged. For more information please contact your account manager and check documentation on Answering Machine Detection.",
        alias="machineDetection",
    )
    max_dtmf: Optional[StrictInt] = Field(
        default=None,
        description="Defines the maximum number of DTMF codes entered by end user that would be collected.",
        alias="maxDtmf",
    )
    notify_content_type: Optional[StrictStr] = Field(
        default=None,
        description="Preferred Delivery report content type. Can be `application/json` or `application/xml`. [Read more](https://www.infobip.com/docs/api#channels/voice/get-voice-delivery-reports).",
        alias="notifyContentType",
    )
    notify_content_version: Optional[StrictInt] = Field(
        default=None,
        description="Specifies the version of the Delivery report to be sent. Can be `1` ([deprecated version 1](#programmable-communications/voice/receive-voice-delivery-reports-deprecated)) or `2` ([current version 2](#programmable-communications/voice/receive-voice-delivery-reports)). The default is version 2. [Read more](https://www.infobip.com/docs/api#channels/voice/get-voice-delivery-reports).",
        alias="notifyContentVersion",
    )
    notify_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the Delivery report will be sent.",
        alias="notifyUrl",
    )
    pause: Optional[StrictInt] = Field(
        default=None,
        description="Period of time in seconds between end user answering the call and message starting to be played. Minimal value is `0` and maximum value is 10 seconds. Default value is `0`.",
    )
    repeat_dtmf: Optional[StrictStr] = Field(
        default=None,
        description="Specify DTMF code that is used as an indicator to repeat the voice message to the end user. The # key cannot be collected, as it is reserved for user input termination. Message can be repeated up to 5 times.",
        alias="repeatDtmf",
    )
    retry: Optional[CallsRetry] = None
    ring_timeout: Optional[StrictInt] = Field(
        default=None,
        description="Ringing duration, unless there are no operator limitations. Default value is `45`. Note: There are no limitations on the Voice platform regarding this value, however, most of the operators have their own ring timeout limitations and it is advisable to keep the ringTimeout value up to `45` seconds.",
        alias="ringTimeout",
    )
    send_at: Optional[datetime] = Field(
        default=None,
        description="Used for scheduled Voice messages (message not to be sent immediately, but at scheduled time).",
        alias="sendAt",
    )
    sending_speed: Optional[CallsSendingSpeed] = Field(
        default=None, alias="sendingSpeed"
    )
    speech_rate: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The reproduction speed of speech in the resulting message. Effective only when using text. Supported range is from `0.5` (slow down speech) to `2` (speed up speech). Values less than `0.5` will be replaced with `0.5`, and values higher than `2` will be replaced with `2`. Default value is `1`.",
        alias="speechRate",
    )
    text: Optional[StrictStr] = Field(
        default=None,
        description="Text of the message that will be sent. Message text can be up to 1400 characters long and cannot contain only punctuation. Adding _pauses_ between the words and extending the duration of the voice message is possible by using the comma character `“,”`. For example, if you want to have a 3 second pause after each word, then the text parameter should look like this `“one,,,,,,two,,,,,,three,,,,,,”`. Each comma creates a pause of 0.5 seconds. SSML (_Speech Synthesis Markup Language_) is supported and can be used to fully customize pronunciation of the provided text.",
    )
    validity_period: Optional[StrictInt] = Field(
        default=None,
        description="The message validity period shown in minutes. When the period expires, it will not be allowed for the message to be sent. A validity period longer than 48h is not supported (in this case, it will be automatically set to 48h).",
        alias="validityPeriod",
    )
    voice: Optional[CallsVoice] = None
    __properties: ClassVar[List[str]] = [
        "audioFileUrl",
        "callTimeout",
        "callTransfers",
        "callbackData",
        "deliveryTimeWindow",
        "destinations",
        "dtmfTimeout",
        "from",
        "language",
        "machineDetection",
        "maxDtmf",
        "notifyContentType",
        "notifyContentVersion",
        "notifyUrl",
        "pause",
        "repeatDtmf",
        "retry",
        "ringTimeout",
        "sendAt",
        "sendingSpeed",
        "speechRate",
        "text",
        "validityPeriod",
        "voice",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsAdvancedMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in call_transfers (list)
        _items = []
        if self.call_transfers:
            for _item_call_transfers in self.call_transfers:
                if _item_call_transfers:
                    _items.append(_item_call_transfers.to_dict())
            _dict["callTransfers"] = _items
        # override the default output from pydantic by calling `to_dict()` of delivery_time_window
        if self.delivery_time_window:
            _dict["deliveryTimeWindow"] = self.delivery_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item_destinations in self.destinations:
                if _item_destinations:
                    _items.append(_item_destinations.to_dict())
            _dict["destinations"] = _items
        # override the default output from pydantic by calling `to_dict()` of retry
        if self.retry:
            _dict["retry"] = self.retry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sending_speed
        if self.sending_speed:
            _dict["sendingSpeed"] = self.sending_speed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of voice
        if self.voice:
            _dict["voice"] = self.voice.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsAdvancedMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "audioFileUrl": obj.get("audioFileUrl"),
                "callTimeout": obj.get("callTimeout"),
                "callTransfers": (
                    [CallTransfer.from_dict(_item) for _item in obj["callTransfers"]]
                    if obj.get("callTransfers") is not None
                    else None
                ),
                "callbackData": obj.get("callbackData"),
                "deliveryTimeWindow": (
                    DeliveryTimeWindow.from_dict(obj["deliveryTimeWindow"])
                    if obj.get("deliveryTimeWindow") is not None
                    else None
                ),
                "destinations": (
                    [CallsDestination.from_dict(_item) for _item in obj["destinations"]]
                    if obj.get("destinations") is not None
                    else None
                ),
                "dtmfTimeout": obj.get("dtmfTimeout"),
                "from": obj.get("from"),
                "language": obj.get("language"),
                "machineDetection": obj.get("machineDetection"),
                "maxDtmf": obj.get("maxDtmf"),
                "notifyContentType": obj.get("notifyContentType"),
                "notifyContentVersion": obj.get("notifyContentVersion"),
                "notifyUrl": obj.get("notifyUrl"),
                "pause": obj.get("pause"),
                "repeatDtmf": obj.get("repeatDtmf"),
                "retry": (
                    CallsRetry.from_dict(obj["retry"])
                    if obj.get("retry") is not None
                    else None
                ),
                "ringTimeout": obj.get("ringTimeout"),
                "sendAt": obj.get("sendAt"),
                "sendingSpeed": (
                    CallsSendingSpeed.from_dict(obj["sendingSpeed"])
                    if obj.get("sendingSpeed") is not None
                    else None
                ),
                "speechRate": obj.get("speechRate"),
                "text": obj.get("text"),
                "validityPeriod": obj.get("validityPeriod"),
                "voice": (
                    CallsVoice.from_dict(obj["voice"])
                    if obj.get("voice") is not None
                    else None
                ),
            }
        )
        return _obj
