# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_answering_machine_detection_options import (
    CallsAnsweringMachineDetectionOptions,
)
from typing import Optional, Set
from typing_extensions import Self


class CallsAnsweringMachineDetection(BaseModel):
    """
    This action detects answering machines at the beginning of a call. It allows for detailed configuration of actions to be executed at various stages of the detection process.
    """  # noqa: E501

    answering_machine_detection: StrictBool = Field(
        description="Indicates whether machine detection should be performed.",
        alias="answeringMachineDetection",
    )
    options: Optional[CallsAnsweringMachineDetectionOptions] = None
    on_detecting: Optional[List[Dict[str, Any]]] = Field(
        default=None,
        description="Array of actions to execute while detection is in progress. A maximum of two actions of specific types (`Play`, `Say`, `Collect`) can be defined.",
        alias="onDetecting",
    )
    on_machine_detected: List[Dict[str, Any]] = Field(
        description="Array of actions to execute when a machine is detected, or when the end of the message is reached if `endOfMessageDetectionTimeout` is set. Actions defined in `onDetecting` are interrupted before these actions begin. If you do not intend to continue the scenario after `onMachineDetected`, include a `Hangup` action at the end of this section to terminate the call.",
        alias="onMachineDetected",
    )
    on_timeout: Optional[List[Dict[str, Any]]] = Field(
        default=None,
        description="Array of actions to execute when a machine is detected and the `endOfMessageDetectionTimeout` is reached. If you do not intend to continue the scenario after `onTimeout`, include a `Hangup` action at the end of this section to terminate the call.",
        alias="onTimeout",
    )
    on_human_detected: Optional[List[Dict[str, Any]]] = Field(
        default=None,
        description="Array of actions to execute when a human is detected. Actions defined in `onDetecting` are interrupted before these actions begin. To avoid this interruption, omit this section and define the remaining scenario after this action. If you do not intend to continue the scenario after `onHumanDetected`, include a `Hangup` action at the end of this section to terminate the call.",
        alias="onHumanDetected",
    )
    __properties: ClassVar[List[str]] = [
        "answeringMachineDetection",
        "options",
        "onDetecting",
        "onMachineDetected",
        "onTimeout",
        "onHumanDetected",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsAnsweringMachineDetection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict["options"] = self.options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsAnsweringMachineDetection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "answeringMachineDetection": obj.get("answeringMachineDetection"),
                "options": (
                    CallsAnsweringMachineDetectionOptions.from_dict(obj["options"])
                    if obj.get("options") is not None
                    else None
                ),
                "onDetecting": obj.get("onDetecting"),
                "onMachineDetected": obj.get("onMachineDetected"),
                "onTimeout": obj.get("onTimeout"),
                "onHumanDetected": obj.get("onHumanDetected"),
            }
        )
        return _obj
