# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.calls_dialog_call_request import CallsDialogCallRequest
from infobip_api_client.models.calls_dialog_propagation_options import (
    CallsDialogPropagationOptions,
)
from infobip_api_client.models.calls_dialog_recording_request import (
    CallsDialogRecordingRequest,
)
from typing import Optional, Set
from typing_extensions import Self


class CallsDialogRequest(BaseModel):
    """
    CallsDialogRequest
    """  # noqa: E501

    parent_call_id: Annotated[str, Field(strict=True, max_length=128)] = Field(
        description="Unique parent call ID.", alias="parentCallId"
    )
    child_call_request: Optional[CallsDialogCallRequest] = Field(
        default=None, alias="childCallRequest"
    )
    recording: Optional[CallsDialogRecordingRequest] = None
    max_duration: Optional[StrictInt] = Field(
        default=28800, description="Max duration in seconds.", alias="maxDuration"
    )
    propagation_options: Optional[CallsDialogPropagationOptions] = Field(
        default=None, alias="propagationOptions"
    )
    __properties: ClassVar[List[str]] = [
        "parentCallId",
        "childCallRequest",
        "recording",
        "maxDuration",
        "propagationOptions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsDialogRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of child_call_request
        if self.child_call_request:
            _dict["childCallRequest"] = self.child_call_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recording
        if self.recording:
            _dict["recording"] = self.recording.to_dict()
        # override the default output from pydantic by calling `to_dict()` of propagation_options
        if self.propagation_options:
            _dict["propagationOptions"] = self.propagation_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsDialogRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "parentCallId": obj.get("parentCallId"),
                "childCallRequest": (
                    CallsDialogCallRequest.from_dict(obj["childCallRequest"])
                    if obj.get("childCallRequest") is not None
                    else None
                ),
                "recording": (
                    CallsDialogRecordingRequest.from_dict(obj["recording"])
                    if obj.get("recording") is not None
                    else None
                ),
                "maxDuration": (
                    obj.get("maxDuration")
                    if obj.get("maxDuration") is not None
                    else 28800
                ),
                "propagationOptions": (
                    CallsDialogPropagationOptions.from_dict(obj["propagationOptions"])
                    if obj.get("propagationOptions") is not None
                    else None
                ),
            }
        )
        return _obj
