# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from infobip_api_client.models.calls_language import CallsLanguage
from infobip_api_client.models.calls_play_content import CallsPlayContent
from infobip_api_client.models.calls_play_content_type import CallsPlayContentType
from infobip_api_client.models.calls_voice_preferences import CallsVoicePreferences
from typing import Optional, Set
from typing_extensions import Self


class CallsTextPlayContent(CallsPlayContent):
    """
    CallsTextPlayContent
    """  # noqa: E501

    text: StrictStr = Field(
        description="Text to read. Use the Speech Synthesis Markup Language (SSML) in a request to fine-tune your output."
    )
    language: CallsLanguage
    speech_rate: Optional[
        Union[
            Annotated[float, Field(le=2, strict=True, ge=0.5)],
            Annotated[int, Field(le=2, strict=True, ge=1)],
        ]
    ] = Field(default=None, alias="speechRate")
    preferences: Optional[CallsVoicePreferences] = None
    type: CallsPlayContentType = "TEXT"
    __properties: ClassVar[List[str]] = [
        "type",
        "text",
        "language",
        "speechRate",
        "preferences",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsTextPlayContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of preferences
        if self.preferences:
            _dict["preferences"] = self.preferences.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsTextPlayContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "text": obj.get("text"),
                "language": obj.get("language"),
                "speechRate": obj.get("speechRate"),
                "preferences": (
                    CallsVoicePreferences.from_dict(obj["preferences"])
                    if obj.get("preferences") is not None
                    else None
                ),
            }
        )
        return _obj
