# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.email_media_attachment import EmailMediaAttachment
from infobip_api_client.models.email_media_inline_image import EmailMediaInlineImage
from typing import Optional, Set
from typing_extensions import Self


class EmailMessageContent(BaseModel):
    """
    Message content.
    """  # noqa: E501

    subject: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=1000)]
    ] = Field(
        default=None,
        description="Message subject.  Note: This field is required if `templateId` is not present.",
    )
    text: Optional[StrictStr] = Field(default=None, description="Body of the message.")
    html: Optional[StrictStr] = Field(
        default=None,
        description="The message's body in HTML format. If both `html` and `text` fields are included, the `text` field will be disregarded, and the message will be sent using the `html` content. ",
    )
    amp_html: Optional[StrictStr] = Field(
        default=None,
        description="The message's body in AMP HTML format. If you include `ampHtml`, you must also include `html`, which will be displayed if AMP is not supported. Keep in mind that not all email clients support AMP HTML. For guidance on configuring the Gmail client, please visit this link: https://developers.google.com/gmail/ampemail/ .",
        alias="ampHtml",
    )
    template_id: Optional[StrictStr] = Field(
        default=None,
        description="The Template ID with predefined email content created through the Infobip web interface or API. When `templateId` is specified, the `html` and `text` fields will be disregarded. Note: `templateId` only supports the `Broadcast` value; `Content` and `Flow` templates are not supported.",
        alias="templateId",
    )
    attachments: Optional[List[EmailMediaAttachment]] = Field(
        default=None, description="File attachment."
    )
    inline_images: Optional[List[EmailMediaInlineImage]] = Field(
        default=None,
        description="Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image. ",
        alias="inlineImages",
    )
    default_placeholders: Optional[StrictStr] = Field(
        default=None,
        description='General placeholders: `{"ph1": "Success"}` will replace the key `{{ph1}}` with the value Success throughout the email, including the `subject`, `text`, and HTML. If there are multiple recipients in the To field, this placeholder will use the same value for the key ph1 for all recipients.',
        alias="defaultPlaceholders",
    )
    landing_page_placeholders: Optional[StrictStr] = Field(
        default=None,
        description='Personalize Opt-Out Landing Page by inserting placeholders. Insert placeholder or tag while designing landing page. Value should be defined as: `{"unsubscribe": "Unsubscribe"}`',
        alias="landingPagePlaceholders",
    )
    optout_landing_page_id: Optional[StrictStr] = Field(
        default=None,
        description="The Opt-Out Landing Page ID specifies the page to be displayed when an end user clicks the unsubscribe link. If the ID is not provided, the default opt-out landing page will be used. Create a landing page over Infobip web interface and use its ID, for example, `1_23456.`",
        alias="optoutLandingPageId",
    )
    template_language_version: Optional[StrictStr] = Field(
        default="1",
        description="Indicates the version of the template language to be used in the current message template. Use version 1 for the older template language and version 2 to access features of the new template language. If not specified, version 1 will be used by default.",
        alias="templateLanguageVersion",
    )
    headers: Optional[StrictStr] = Field(
        default=None,
        description='Additional email headers for customization that can be provided in a form of JSON. Example: `headers={"X-CustomHeader": "Header value"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`',
    )
    __properties: ClassVar[List[str]] = [
        "subject",
        "text",
        "html",
        "ampHtml",
        "templateId",
        "attachments",
        "inlineImages",
        "defaultPlaceholders",
        "landingPagePlaceholders",
        "optoutLandingPageId",
        "templateLanguageVersion",
        "headers",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailMessageContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict["attachments"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in inline_images (list)
        _items = []
        if self.inline_images:
            for _item_inline_images in self.inline_images:
                if _item_inline_images:
                    _items.append(_item_inline_images.to_dict())
            _dict["inlineImages"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailMessageContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "subject": obj.get("subject"),
                "text": obj.get("text"),
                "html": obj.get("html"),
                "ampHtml": obj.get("ampHtml"),
                "templateId": obj.get("templateId"),
                "attachments": (
                    [
                        EmailMediaAttachment.from_dict(_item)
                        for _item in obj["attachments"]
                    ]
                    if obj.get("attachments") is not None
                    else None
                ),
                "inlineImages": (
                    [
                        EmailMediaInlineImage.from_dict(_item)
                        for _item in obj["inlineImages"]
                    ]
                    if obj.get("inlineImages") is not None
                    else None
                ),
                "defaultPlaceholders": obj.get("defaultPlaceholders"),
                "landingPagePlaceholders": obj.get("landingPagePlaceholders"),
                "optoutLandingPageId": obj.get("optoutLandingPageId"),
                "templateLanguageVersion": (
                    obj.get("templateLanguageVersion")
                    if obj.get("templateLanguageVersion") is not None
                    else "1"
                ),
                "headers": obj.get("headers"),
            }
        )
        return _obj
