# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.email_message_status import EmailMessageStatus
from typing import Optional, Set
from typing_extensions import Self


class EmailMessageResponseMessageResponseDetails(BaseModel):
    """
    An array of message objects of a single message or multiple messages sent under one bulk ID.
    """  # noqa: E501

    message_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique message ID. If not provided, it will be auto-generated and returned in the API response.",
        alias="messageId",
    )
    status: Optional[EmailMessageStatus] = None
    destination: Optional[StrictStr] = Field(
        default=None,
        description="The destination address of the message, i.e., its recipient.",
    )
    details: Optional[Dict[str, Any]] = Field(
        default=None, description="Other details of the message."
    )
    __properties: ClassVar[List[str]] = [
        "messageId",
        "status",
        "destination",
        "details",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailMessageResponseMessageResponseDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailMessageResponseMessageResponseDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "messageId": obj.get("messageId"),
                "status": (
                    EmailMessageStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
                "destination": obj.get("destination"),
                "details": obj.get("details"),
            }
        )
        return _obj
