# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.email_validation_api_risk import EmailValidationApiRisk
from infobip_api_client.models.email_validation_reason import EmailValidationReason
from typing import Optional, Set
from typing_extensions import Self


class EmailValidationResponse(BaseModel):
    """
    Validation response
    """  # noqa: E501

    to: StrictStr = Field(description="The validated email address.")
    valid_mailbox: StrictStr = Field(
        description="Indicates whether email address is valid.", alias="validMailbox"
    )
    valid_syntax: StrictBool = Field(
        description="Indicates whether email address syntax is valid.",
        alias="validSyntax",
    )
    catch_all: StrictBool = Field(
        description="Indicates catch all status of email address.", alias="catchAll"
    )
    did_you_mean: Optional[StrictStr] = Field(
        default=None,
        description="Suggests similar alternate address that may be valid.",
        alias="didYouMean",
    )
    disposable: StrictBool = Field(
        description="Indicates whether email address is disposable. A disposable email address is a temporary address that is often used for short-term purposes and can be discarded after use. "
    )
    role_based: StrictBool = Field(
        description="Indicates whether email address is role-based. A role-based email address is one that is associated with a specific function or group within an organization, such as marketing@example.org, rather than an individual person. ",
        alias="roleBased",
    )
    reason: Optional[EmailValidationReason] = None
    risk: EmailValidationApiRisk
    detailed_reasons: Optional[StrictStr] = Field(
        default=None,
        description="This field is provided when the validMailbox status is 'unknown' or 'false', offering specific explanations for why the email address has been assigned that status. ",
        alias="detailedReasons",
    )
    __properties: ClassVar[List[str]] = [
        "to",
        "validMailbox",
        "validSyntax",
        "catchAll",
        "didYouMean",
        "disposable",
        "roleBased",
        "reason",
        "risk",
        "detailedReasons",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailValidationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailValidationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "to": obj.get("to"),
                "validMailbox": obj.get("validMailbox"),
                "validSyntax": obj.get("validSyntax"),
                "catchAll": obj.get("catchAll"),
                "didYouMean": obj.get("didYouMean"),
                "disposable": obj.get("disposable"),
                "roleBased": obj.get("roleBased"),
                "reason": obj.get("reason"),
                "risk": obj.get("risk"),
                "detailedReasons": obj.get("detailedReasons"),
            }
        )
        return _obj
