# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.flow_person import FlowPerson
from infobip_api_client.models.flow_person_unique_field import FlowPersonUniqueField
from typing import Optional, Set
from typing_extensions import Self


class FlowParticipant(BaseModel):
    """
    Participant to be added to Flow campaign.
    """  # noqa: E501

    identify_by: FlowPersonUniqueField = Field(alias="identifyBy")
    variables: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Flow variables to assign to the participant when it is added to the flow.",
    )
    person: Optional[FlowPerson] = None
    __properties: ClassVar[List[str]] = ["identifyBy", "variables", "person"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of identify_by
        if self.identify_by:
            _dict["identifyBy"] = self.identify_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "identifyBy": (
                    FlowPersonUniqueField.from_dict(obj["identifyBy"])
                    if obj.get("identifyBy") is not None
                    else None
                ),
                "variables": obj.get("variables"),
                "person": (
                    FlowPerson.from_dict(obj["person"])
                    if obj.get("person") is not None
                    else None
                ),
            }
        )
        return _obj
