# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.forms_response_content import FormsResponseContent
from typing import Optional, Set
from typing_extensions import Self


class FormsResponse(BaseModel):
    """
    FormsResponse
    """  # noqa: E501

    forms: List[FormsResponseContent] = Field(description="Forms list")
    offset: Optional[StrictInt] = Field(
        default=None, description="Offset from beginning of list of available forms"
    )
    limit: Optional[StrictInt] = Field(
        default=None, description="Number of returned forms"
    )
    total: Optional[StrictInt] = Field(
        default=None, description="Total number of available forms"
    )
    __properties: ClassVar[List[str]] = ["forms", "offset", "limit", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FormsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in forms (list)
        _items = []
        if self.forms:
            for _item_forms in self.forms:
                if _item_forms:
                    _items.append(_item_forms.to_dict())
            _dict["forms"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FormsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "forms": (
                    [FormsResponseContent.from_dict(_item) for _item in obj["forms"]]
                    if obj.get("forms") is not None
                    else None
                ),
                "offset": obj.get("offset"),
                "limit": obj.get("limit"),
                "total": obj.get("total"),
            }
        )
        return _obj
