# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.forms_action_after_submission import (
    FormsActionAfterSubmission,
)
from infobip_api_client.models.forms_element import FormsElement
from infobip_api_client.models.forms_status import FormsStatus
from infobip_api_client.models.forms_type import FormsType
from typing import Optional, Set
from typing_extensions import Self


class FormsResponseContent(BaseModel):
    """
    FormsResponseContent
    """  # noqa: E501

    id: StrictStr = Field(description="Form identifier")
    name: StrictStr = Field(description="Form name")
    elements: List[FormsElement] = Field(description="List of form fields")
    created_at: Optional[datetime] = Field(
        default=None, description="Time when form was created", alias="createdAt"
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description="Time when form was update last time",
        alias="updatedAt",
    )
    action_after_submission: Optional[FormsActionAfterSubmission] = Field(
        default=None, alias="actionAfterSubmission"
    )
    resubmit_enabled: StrictBool = Field(
        description="Can resubmit multiple times", alias="resubmitEnabled"
    )
    form_type: FormsType = Field(alias="formType")
    form_status: FormsStatus = Field(alias="formStatus")
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "elements",
        "createdAt",
        "updatedAt",
        "actionAfterSubmission",
        "resubmitEnabled",
        "formType",
        "formStatus",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FormsResponseContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in elements (list)
        _items = []
        if self.elements:
            for _item_elements in self.elements:
                if _item_elements:
                    _items.append(_item_elements.to_dict())
            _dict["elements"] = _items
        # override the default output from pydantic by calling `to_dict()` of action_after_submission
        if self.action_after_submission:
            _dict["actionAfterSubmission"] = self.action_after_submission.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FormsResponseContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "elements": (
                    [FormsElement.from_dict(_item) for _item in obj["elements"]]
                    if obj.get("elements") is not None
                    else None
                ),
                "createdAt": obj.get("createdAt"),
                "updatedAt": obj.get("updatedAt"),
                "actionAfterSubmission": (
                    FormsActionAfterSubmission.from_dict(obj["actionAfterSubmission"])
                    if obj.get("actionAfterSubmission") is not None
                    else None
                ),
                "resubmitEnabled": obj.get("resubmitEnabled"),
                "formType": obj.get("formType"),
                "formStatus": obj.get("formStatus"),
            }
        )
        return _obj
