# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
import pprint
from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing import Any, Optional
from infobip_api_client.models.messages_api_failover import MessagesApiFailover
from infobip_api_client.models.messages_api_template_failover import (
    MessagesApiTemplateFailover,
)
from typing import Union, Set, Optional, Dict
from typing_extensions import Self

MESSAGESAPIBASEFAILOVER_ONE_OF_SCHEMAS = [
    "MessagesApiFailover",
    "MessagesApiTemplateFailover",
]


class MessagesApiBaseFailover(BaseModel):
    """
    Provides options for configuring a message failover. When message fails it will be sent over channels in order specified in an array. It has to contain unique entries per channel and it cannot contain entry with the same channel as original message. **Make sure to provide correct sender and destinations specified as `Channels Destination` for each channel**.
    """

    # data type: MessagesApiFailover
    oneof_schema_1_validator: Optional[MessagesApiFailover] = None
    # data type: MessagesApiTemplateFailover
    oneof_schema_2_validator: Optional[MessagesApiTemplateFailover] = None
    actual_instance: Optional[
        Union[MessagesApiFailover, MessagesApiTemplateFailover]
    ] = None
    one_of_schemas: Set[str] = {"MessagesApiFailover", "MessagesApiTemplateFailover"}

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = MessagesApiBaseFailover.model_construct()
        error_messages = []
        match = 0
        # validate data type: MessagesApiFailover
        if not isinstance(v, MessagesApiFailover):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MessagesApiFailover`"
            )
        else:
            match += 1
        # validate data type: MessagesApiTemplateFailover
        if not isinstance(v, MessagesApiTemplateFailover):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MessagesApiTemplateFailover`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in MessagesApiBaseFailover with oneOf schemas: MessagesApiFailover, MessagesApiTemplateFailover. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in MessagesApiBaseFailover with oneOf schemas: MessagesApiFailover, MessagesApiTemplateFailover. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into MessagesApiFailover
        try:
            instance.actual_instance = MessagesApiFailover.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessagesApiTemplateFailover
        try:
            instance.actual_instance = MessagesApiTemplateFailover.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into MessagesApiBaseFailover with oneOf schemas: MessagesApiFailover, MessagesApiTemplateFailover. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into MessagesApiBaseFailover with oneOf schemas: MessagesApiFailover, MessagesApiTemplateFailover. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[Dict[str, Any], MessagesApiFailover, MessagesApiTemplateFailover]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
