# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Union
from infobip_api_client.models.messages_api_message_form_page_type import (
    MessagesApiMessageFormPageType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.messages_api_message_date_picker_form_page import (
        MessagesApiMessageDatePickerFormPage,
    )
    from infobip_api_client.models.messages_api_message_input_form_page import (
        MessagesApiMessageInputFormPage,
    )
    from infobip_api_client.models.messages_api_message_intro_form_page import (
        MessagesApiMessageIntroFormPage,
    )
    from infobip_api_client.models.messages_api_message_picker_form_page import (
        MessagesApiMessagePickerFormPage,
    )
    from infobip_api_client.models.messages_api_message_select_form_page import (
        MessagesApiMessageSelectFormPage,
    )


class MessagesApiMessageFormPage(BaseModel):
    """
    An array of different pages to be shown in the form. If INTRO page is included it will always appear first.
    """  # noqa: E501

    type: MessagesApiMessageFormPageType
    __properties: ClassVar[List[str]] = ["type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "DATE_PICKER": "MessagesApiMessageDatePickerFormPage",
        "INPUT": "MessagesApiMessageInputFormPage",
        "INTRO": "MessagesApiMessageIntroFormPage",
        "PICKER": "MessagesApiMessagePickerFormPage",
        "SELECT": "MessagesApiMessageSelectFormPage",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            MessagesApiMessageDatePickerFormPage,
            MessagesApiMessageInputFormPage,
            MessagesApiMessageIntroFormPage,
            MessagesApiMessagePickerFormPage,
            MessagesApiMessageSelectFormPage,
        ]
    ]:
        """Create an instance of MessagesApiMessageFormPage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            MessagesApiMessageDatePickerFormPage,
            MessagesApiMessageInputFormPage,
            MessagesApiMessageIntroFormPage,
            MessagesApiMessagePickerFormPage,
            MessagesApiMessageSelectFormPage,
        ]
    ]:
        """Create an instance of MessagesApiMessageFormPage from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MessagesApiMessageDatePickerFormPage":
            return import_module(
                "infobip_api_client.models.messages_api_message_date_picker_form_page"
            ).MessagesApiMessageDatePickerFormPage.from_dict(obj)
        if object_type == "MessagesApiMessageInputFormPage":
            return import_module(
                "infobip_api_client.models.messages_api_message_input_form_page"
            ).MessagesApiMessageInputFormPage.from_dict(obj)
        if object_type == "MessagesApiMessageIntroFormPage":
            return import_module(
                "infobip_api_client.models.messages_api_message_intro_form_page"
            ).MessagesApiMessageIntroFormPage.from_dict(obj)
        if object_type == "MessagesApiMessagePickerFormPage":
            return import_module(
                "infobip_api_client.models.messages_api_message_picker_form_page"
            ).MessagesApiMessagePickerFormPage.from_dict(obj)
        if object_type == "MessagesApiMessageSelectFormPage":
            return import_module(
                "infobip_api_client.models.messages_api_message_select_form_page"
            ).MessagesApiMessageSelectFormPage.from_dict(obj)

        raise ValueError(
            "MessagesApiMessageFormPage failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
