# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_message_order_currency import (
    MessagesApiMessageOrderCurrency,
)
from infobip_api_client.models.messages_api_message_order_details_type import (
    MessagesApiMessageOrderDetailsType,
)
from infobip_api_client.models.messages_api_message_order_expiration import (
    MessagesApiMessageOrderExpiration,
)
from infobip_api_client.models.messages_api_message_order_item import (
    MessagesApiMessageOrderItem,
)
from infobip_api_client.models.messages_api_message_order_type import (
    MessagesApiMessageOrderType,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessageOrder(BaseModel):
    """
    Payment request order.
    """  # noqa: E501

    catalog_id: Optional[StrictStr] = Field(
        default=None,
        description="(WhatsApp specific) ID that uniquely identifies the [catalog](https://www.infobip.com/docs/api/platform/catalogs-api) registered with Facebook and connected to the WhatsApp Business Account the sender belongs to.",
        alias="catalogId",
    )
    currency: Optional[MessagesApiMessageOrderCurrency] = None
    type: Optional[MessagesApiMessageOrderType] = None
    details_type: Optional[MessagesApiMessageOrderDetailsType] = Field(
        default=None, alias="detailsType"
    )
    items: Optional[List[MessagesApiMessageOrderItem]] = Field(
        default=None, description="An array of items in the order."
    )
    expiration: Optional[MessagesApiMessageOrderExpiration] = None
    __properties: ClassVar[List[str]] = [
        "catalogId",
        "currency",
        "type",
        "detailsType",
        "items",
        "expiration",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict["items"] = _items
        # override the default output from pydantic by calling `to_dict()` of expiration
        if self.expiration:
            _dict["expiration"] = self.expiration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessageOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "catalogId": obj.get("catalogId"),
                "currency": obj.get("currency"),
                "type": obj.get("type"),
                "detailsType": obj.get("detailsType"),
                "items": (
                    [
                        MessagesApiMessageOrderItem.from_dict(_item)
                        for _item in obj["items"]
                    ]
                    if obj.get("items") is not None
                    else None
                ),
                "expiration": (
                    MessagesApiMessageOrderExpiration.from_dict(obj["expiration"])
                    if obj.get("expiration") is not None
                    else None
                ),
            }
        )
        return _obj
