# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from infobip_api_client.models.messages_api_descriptive_total_amount import (
    MessagesApiDescriptiveTotalAmount,
)
from infobip_api_client.models.messages_api_message_descriptive_discount_amount import (
    MessagesApiMessageDescriptiveDiscountAmount,
)
from infobip_api_client.models.messages_api_message_descriptive_tax_amount import (
    MessagesApiMessageDescriptiveTaxAmount,
)
from infobip_api_client.models.messages_api_message_payment_configuration import (
    MessagesApiMessagePaymentConfiguration,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiMessagePayment(BaseModel):
    """
    Request payment data.
    """  # noqa: E501

    configuration: Optional[MessagesApiMessagePaymentConfiguration] = None
    total: Optional[MessagesApiDescriptiveTotalAmount] = None
    subtotal: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="(WhatsApp specific, required) Sub-total amount of the order (up to 2 decimal places). For WhatsApp it has to be multiplied by offset (100 for `INR` and `BRL`)",
    )
    tax: Optional[MessagesApiMessageDescriptiveTaxAmount] = None
    discount: Optional[MessagesApiMessageDescriptiveDiscountAmount] = None
    __properties: ClassVar[List[str]] = [
        "configuration",
        "total",
        "subtotal",
        "tax",
        "discount",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiMessagePayment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict["configuration"] = self.configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total
        if self.total:
            _dict["total"] = self.total.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tax
        if self.tax:
            _dict["tax"] = self.tax.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict["discount"] = self.discount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiMessagePayment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "configuration": (
                    MessagesApiMessagePaymentConfiguration.from_dict(
                        obj["configuration"]
                    )
                    if obj.get("configuration") is not None
                    else None
                ),
                "total": (
                    MessagesApiDescriptiveTotalAmount.from_dict(obj["total"])
                    if obj.get("total") is not None
                    else None
                ),
                "subtotal": obj.get("subtotal"),
                "tax": (
                    MessagesApiMessageDescriptiveTaxAmount.from_dict(obj["tax"])
                    if obj.get("tax") is not None
                    else None
                ),
                "discount": (
                    MessagesApiMessageDescriptiveDiscountAmount.from_dict(
                        obj["discount"]
                    )
                    if obj.get("discount") is not None
                    else None
                ),
            }
        )
        return _obj
