# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.messages_api_event_options import MessagesApiEventOptions
from infobip_api_client.models.messages_api_outbound_event import (
    MessagesApiOutboundEvent,
)
from infobip_api_client.models.messages_api_outbound_event_channel import (
    MessagesApiOutboundEventChannel,
)
from infobip_api_client.models.messages_api_outbound_event_type import (
    MessagesApiOutboundEventType,
)
from infobip_api_client.models.messages_api_to_destination import (
    MessagesApiToDestination,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiOutboundTypingStartedEvent(MessagesApiOutboundEvent):
    """
    MessagesApiOutboundTypingStartedEvent
    """  # noqa: E501

    channel: MessagesApiOutboundEventChannel
    sender: StrictStr = Field(
        description="The sender ID. It can be alphanumeric or numeric (e.g., `CompanyName`). Make sure you don't exceed [character limit](https://www.infobip.com/docs/sms/get-started#sender-names)."
    )
    destinations: List[MessagesApiToDestination] = Field(
        description="Array of destination objects for where events are being sent. A valid destination is required."
    )
    options: Optional[MessagesApiEventOptions] = None
    event: MessagesApiOutboundEventType = "TYPING_STARTED"
    __properties: ClassVar[List[str]] = [
        "event",
        "channel",
        "sender",
        "destinations",
        "options",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiOutboundTypingStartedEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item_destinations in self.destinations:
                if _item_destinations:
                    _items.append(_item_destinations.to_dict())
            _dict["destinations"] = _items
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict["options"] = self.options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiOutboundTypingStartedEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "event": obj.get("event"),
                "channel": obj.get("channel"),
                "sender": obj.get("sender"),
                "destinations": (
                    [
                        MessagesApiToDestination.from_dict(_item)
                        for _item in obj["destinations"]
                    ]
                    if obj.get("destinations") is not None
                    else None
                ),
                "options": (
                    MessagesApiEventOptions.from_dict(obj["options"])
                    if obj.get("options") is not None
                    else None
                ),
            }
        )
        return _obj
